/*
 * Decompiled with CFR 0.152.
 */
package shaded.alink.kafka.org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import shaded.alink.kafka.org.apache.kafka.common.TopicPartition;
import shaded.alink.kafka.org.apache.kafka.common.protocol.ApiKeys;
import shaded.alink.kafka.org.apache.kafka.common.protocol.CommonFields;
import shaded.alink.kafka.org.apache.kafka.common.protocol.Errors;
import shaded.alink.kafka.org.apache.kafka.common.protocol.types.Field;
import shaded.alink.kafka.org.apache.kafka.common.protocol.types.Schema;
import shaded.alink.kafka.org.apache.kafka.common.protocol.types.Struct;
import shaded.alink.kafka.org.apache.kafka.common.requests.AbstractResponse;
import shaded.alink.kafka.org.apache.kafka.common.utils.CollectionUtils;

public class OffsetCommitResponse
extends AbstractResponse {
    private static final Field.ComplexArray TOPICS = new Field.ComplexArray("responses", "Responses by topic for committed partitions");
    private static final Field.ComplexArray PARTITIONS = new Field.ComplexArray("partition_responses", "Responses for committed partitions");
    private static final Field PARTITIONS_V0 = PARTITIONS.withFields(CommonFields.PARTITION_ID, CommonFields.ERROR_CODE);
    private static final Field TOPICS_V0 = TOPICS.withFields(CommonFields.TOPIC_NAME, PARTITIONS_V0);
    private static final Schema OFFSET_COMMIT_RESPONSE_V0;
    private static final Schema OFFSET_COMMIT_RESPONSE_V1;
    private static final Schema OFFSET_COMMIT_RESPONSE_V2;
    private static final Schema OFFSET_COMMIT_RESPONSE_V3;
    private static final Schema OFFSET_COMMIT_RESPONSE_V4;
    private static final Schema OFFSET_COMMIT_RESPONSE_V5;
    private static final Schema OFFSET_COMMIT_RESPONSE_V6;
    private final Map<TopicPartition, Errors> responseData;
    private final int throttleTimeMs;

    public static Schema[] schemaVersions() {
        return new Schema[]{OFFSET_COMMIT_RESPONSE_V0, OFFSET_COMMIT_RESPONSE_V1, OFFSET_COMMIT_RESPONSE_V2, OFFSET_COMMIT_RESPONSE_V3, OFFSET_COMMIT_RESPONSE_V4, OFFSET_COMMIT_RESPONSE_V5, OFFSET_COMMIT_RESPONSE_V6};
    }

    public OffsetCommitResponse(Map<TopicPartition, Errors> responseData) {
        this(0, responseData);
    }

    public OffsetCommitResponse(int throttleTimeMs, Map<TopicPartition, Errors> responseData) {
        this.throttleTimeMs = throttleTimeMs;
        this.responseData = responseData;
    }

    public OffsetCommitResponse(Struct struct) {
        this.throttleTimeMs = struct.getOrElse(CommonFields.THROTTLE_TIME_MS, 0);
        this.responseData = new HashMap<TopicPartition, Errors>();
        for (Object topicResponseObj : struct.get(TOPICS)) {
            Struct topicResponse = (Struct)topicResponseObj;
            String topic = topicResponse.get(CommonFields.TOPIC_NAME);
            for (Object partitionResponseObj : topicResponse.get(PARTITIONS)) {
                Struct partitionResponse = (Struct)partitionResponseObj;
                int partition = partitionResponse.get(CommonFields.PARTITION_ID);
                Errors error = Errors.forCode(partitionResponse.get(CommonFields.ERROR_CODE));
                this.responseData.put(new TopicPartition(topic, partition), error);
            }
        }
    }

    @Override
    public Struct toStruct(short version) {
        Struct struct = new Struct(ApiKeys.OFFSET_COMMIT.responseSchema(version));
        struct.setIfExists(CommonFields.THROTTLE_TIME_MS, (Object)this.throttleTimeMs);
        Map<String, Map<Integer, Errors>> topicsData = CollectionUtils.groupPartitionDataByTopic(this.responseData);
        ArrayList<Struct> topicArray = new ArrayList<Struct>();
        for (Map.Entry<String, Map<Integer, Errors>> entries : topicsData.entrySet()) {
            Struct topicData = struct.instance(TOPICS);
            topicData.set(CommonFields.TOPIC_NAME, entries.getKey());
            ArrayList<Struct> partitionArray = new ArrayList<Struct>();
            for (Map.Entry<Integer, Errors> partitionEntry : entries.getValue().entrySet()) {
                Struct partitionData = topicData.instance(PARTITIONS);
                partitionData.set(CommonFields.PARTITION_ID, partitionEntry.getKey());
                partitionData.set(CommonFields.ERROR_CODE, partitionEntry.getValue().code());
                partitionArray.add(partitionData);
            }
            topicData.set(PARTITIONS, partitionArray.toArray());
            topicArray.add(topicData);
        }
        struct.set(TOPICS, topicArray.toArray());
        return struct;
    }

    @Override
    public int throttleTimeMs() {
        return this.throttleTimeMs;
    }

    public Map<TopicPartition, Errors> responseData() {
        return this.responseData;
    }

    @Override
    public Map<Errors, Integer> errorCounts() {
        return this.errorCounts(this.responseData);
    }

    public static OffsetCommitResponse parse(ByteBuffer buffer, short version) {
        return new OffsetCommitResponse(ApiKeys.OFFSET_COMMIT.parseResponse(version, buffer));
    }

    @Override
    public boolean shouldClientThrottle(short version) {
        return version >= 4;
    }

    static {
        OFFSET_COMMIT_RESPONSE_V1 = OFFSET_COMMIT_RESPONSE_V0 = new Schema(TOPICS_V0);
        OFFSET_COMMIT_RESPONSE_V2 = OFFSET_COMMIT_RESPONSE_V0;
        OFFSET_COMMIT_RESPONSE_V6 = OFFSET_COMMIT_RESPONSE_V5 = (OFFSET_COMMIT_RESPONSE_V4 = (OFFSET_COMMIT_RESPONSE_V3 = new Schema(CommonFields.THROTTLE_TIME_MS, TOPICS_V0)));
    }
}

