/*
 * Decompiled with CFR 0.152.
 */
package shaded.alink.kafka.org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import shaded.alink.kafka.org.apache.kafka.common.TopicPartition;
import shaded.alink.kafka.org.apache.kafka.common.protocol.ApiKeys;
import shaded.alink.kafka.org.apache.kafka.common.protocol.CommonFields;
import shaded.alink.kafka.org.apache.kafka.common.protocol.Errors;
import shaded.alink.kafka.org.apache.kafka.common.protocol.types.ArrayOf;
import shaded.alink.kafka.org.apache.kafka.common.protocol.types.Field;
import shaded.alink.kafka.org.apache.kafka.common.protocol.types.Schema;
import shaded.alink.kafka.org.apache.kafka.common.protocol.types.Struct;
import shaded.alink.kafka.org.apache.kafka.common.requests.AbstractResponse;
import shaded.alink.kafka.org.apache.kafka.common.utils.CollectionUtils;

public class AddPartitionsToTxnResponse
extends AbstractResponse {
    private static final String ERRORS_KEY_NAME = "errors";
    private static final String PARTITION_ERRORS = "partition_errors";
    private static final Schema ADD_PARTITIONS_TO_TXN_RESPONSE_V0;
    private static final Schema ADD_PARTITIONS_TO_TXN_RESPONSE_V1;
    private final int throttleTimeMs;
    private final Map<TopicPartition, Errors> errors;

    public static Schema[] schemaVersions() {
        return new Schema[]{ADD_PARTITIONS_TO_TXN_RESPONSE_V0, ADD_PARTITIONS_TO_TXN_RESPONSE_V1};
    }

    public AddPartitionsToTxnResponse(int throttleTimeMs, Map<TopicPartition, Errors> errors) {
        this.throttleTimeMs = throttleTimeMs;
        this.errors = errors;
    }

    public AddPartitionsToTxnResponse(Struct struct) {
        this.throttleTimeMs = struct.get(CommonFields.THROTTLE_TIME_MS);
        this.errors = new HashMap<TopicPartition, Errors>();
        for (Object topic : struct.getArray(ERRORS_KEY_NAME)) {
            Struct topicStruct = (Struct)topic;
            String topicName = topicStruct.get(CommonFields.TOPIC_NAME);
            for (Object partition : topicStruct.getArray(PARTITION_ERRORS)) {
                Struct partitionStruct = (Struct)partition;
                TopicPartition topicPartition = new TopicPartition(topicName, partitionStruct.get(CommonFields.PARTITION_ID));
                this.errors.put(topicPartition, Errors.forCode(partitionStruct.get(CommonFields.ERROR_CODE)));
            }
        }
    }

    @Override
    public int throttleTimeMs() {
        return this.throttleTimeMs;
    }

    public Map<TopicPartition, Errors> errors() {
        return this.errors;
    }

    @Override
    public Map<Errors, Integer> errorCounts() {
        return this.errorCounts(this.errors);
    }

    @Override
    protected Struct toStruct(short version) {
        Struct struct = new Struct(ApiKeys.ADD_PARTITIONS_TO_TXN.responseSchema(version));
        struct.set(CommonFields.THROTTLE_TIME_MS, this.throttleTimeMs);
        Map<String, Map<Integer, Errors>> errorsByTopic = CollectionUtils.groupPartitionDataByTopic(this.errors);
        ArrayList<Struct> topics = new ArrayList<Struct>(errorsByTopic.size());
        for (Map.Entry<String, Map<Integer, Errors>> entry : errorsByTopic.entrySet()) {
            Struct topicErrorCodes = struct.instance(ERRORS_KEY_NAME);
            topicErrorCodes.set(CommonFields.TOPIC_NAME, entry.getKey());
            ArrayList<Struct> partitionArray = new ArrayList<Struct>();
            for (Map.Entry<Integer, Errors> partitionErrors : entry.getValue().entrySet()) {
                Struct partitionData = topicErrorCodes.instance(PARTITION_ERRORS).set(CommonFields.PARTITION_ID, partitionErrors.getKey()).set(CommonFields.ERROR_CODE, partitionErrors.getValue().code());
                partitionArray.add(partitionData);
            }
            topicErrorCodes.set(PARTITION_ERRORS, (Object)partitionArray.toArray());
            topics.add(topicErrorCodes);
        }
        struct.set(ERRORS_KEY_NAME, (Object)topics.toArray());
        return struct;
    }

    public static AddPartitionsToTxnResponse parse(ByteBuffer buffer, short version) {
        return new AddPartitionsToTxnResponse(ApiKeys.ADD_PARTITIONS_TO_TXN.parseResponse(version, buffer));
    }

    public String toString() {
        return "AddPartitionsToTxnResponse(errors=" + this.errors + ", throttleTimeMs=" + this.throttleTimeMs + ')';
    }

    @Override
    public boolean shouldClientThrottle(short version) {
        return version >= 1;
    }

    static {
        ADD_PARTITIONS_TO_TXN_RESPONSE_V1 = ADD_PARTITIONS_TO_TXN_RESPONSE_V0 = new Schema(CommonFields.THROTTLE_TIME_MS, new Field(ERRORS_KEY_NAME, new ArrayOf(new Schema(CommonFields.TOPIC_NAME, new Field(PARTITION_ERRORS, new ArrayOf(new Schema(CommonFields.PARTITION_ID, CommonFields.ERROR_CODE)))))));
    }
}

