/*
 * Decompiled with CFR 0.152.
 */
package shaded.alink.kafka.org.apache.kafka.common.message;

import java.util.ArrayList;
import java.util.List;
import shaded.alink.kafka.org.apache.kafka.common.protocol.ApiMessage;
import shaded.alink.kafka.org.apache.kafka.common.protocol.Message;
import shaded.alink.kafka.org.apache.kafka.common.protocol.MessageUtil;
import shaded.alink.kafka.org.apache.kafka.common.protocol.Readable;
import shaded.alink.kafka.org.apache.kafka.common.protocol.Writable;
import shaded.alink.kafka.org.apache.kafka.common.protocol.types.ArrayOf;
import shaded.alink.kafka.org.apache.kafka.common.protocol.types.Field;
import shaded.alink.kafka.org.apache.kafka.common.protocol.types.Schema;
import shaded.alink.kafka.org.apache.kafka.common.protocol.types.Struct;
import shaded.alink.kafka.org.apache.kafka.common.protocol.types.Type;

public class TxnOffsetCommitResponseData
implements ApiMessage {
    private int throttleTimeMs;
    private List<TxnOffsetCommitResponseTopic> topics;
    public static final Schema SCHEMA_0;
    public static final Schema SCHEMA_1;
    public static final Schema SCHEMA_2;
    public static final Schema[] SCHEMAS;

    public TxnOffsetCommitResponseData(Readable readable, short version) {
        this.topics = new ArrayList<TxnOffsetCommitResponseTopic>();
        this.read(readable, version);
    }

    public TxnOffsetCommitResponseData(Struct struct, short version) {
        this.topics = new ArrayList<TxnOffsetCommitResponseTopic>();
        this.fromStruct(struct, version);
    }

    public TxnOffsetCommitResponseData() {
        this.throttleTimeMs = 0;
        this.topics = new ArrayList<TxnOffsetCommitResponseTopic>();
    }

    @Override
    public short apiKey() {
        return 28;
    }

    @Override
    public short lowestSupportedVersion() {
        return 0;
    }

    @Override
    public short highestSupportedVersion() {
        return 2;
    }

    @Override
    public void read(Readable readable, short version) {
        this.throttleTimeMs = readable.readInt();
        int arrayLength = readable.readInt();
        if (arrayLength < 0) {
            this.topics.clear();
        } else {
            this.topics.clear();
            for (int i = 0; i < arrayLength; ++i) {
                this.topics.add(new TxnOffsetCommitResponseTopic(readable, version));
            }
        }
    }

    @Override
    public void write(Writable writable, short version) {
        writable.writeInt(this.throttleTimeMs);
        writable.writeInt(this.topics.size());
        for (TxnOffsetCommitResponseTopic element : this.topics) {
            element.write(writable, version);
        }
    }

    @Override
    public void fromStruct(Struct struct, short version) {
        this.throttleTimeMs = struct.getInt("throttle_time_ms");
        Object[] nestedObjects = struct.getArray("topics");
        this.topics = new ArrayList<TxnOffsetCommitResponseTopic>(nestedObjects.length);
        for (Object nestedObject : nestedObjects) {
            this.topics.add(new TxnOffsetCommitResponseTopic((Struct)nestedObject, version));
        }
    }

    @Override
    public Struct toStruct(short version) {
        Struct struct = new Struct(SCHEMAS[version]);
        struct.set("throttle_time_ms", (Object)this.throttleTimeMs);
        Struct[] nestedObjects = new Struct[this.topics.size()];
        int i = 0;
        for (TxnOffsetCommitResponseTopic element : this.topics) {
            nestedObjects[i++] = element.toStruct(version);
        }
        struct.set("topics", (Object)nestedObjects);
        return struct;
    }

    @Override
    public int size(short version) {
        int size = 0;
        size += 4;
        size += 4;
        for (TxnOffsetCommitResponseTopic element : this.topics) {
            size += element.size(version);
        }
        return size;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof TxnOffsetCommitResponseData)) {
            return false;
        }
        TxnOffsetCommitResponseData other = (TxnOffsetCommitResponseData)obj;
        if (this.throttleTimeMs != other.throttleTimeMs) {
            return false;
        }
        return !(this.topics == null ? other.topics != null : !this.topics.equals(other.topics));
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + this.throttleTimeMs;
        hashCode = 31 * hashCode + (this.topics == null ? 0 : this.topics.hashCode());
        return hashCode;
    }

    public String toString() {
        return "TxnOffsetCommitResponseData(throttleTimeMs=" + this.throttleTimeMs + ", topics=" + MessageUtil.deepToString(this.topics.iterator()) + ")";
    }

    public int throttleTimeMs() {
        return this.throttleTimeMs;
    }

    public List<TxnOffsetCommitResponseTopic> topics() {
        return this.topics;
    }

    public TxnOffsetCommitResponseData setThrottleTimeMs(int v) {
        this.throttleTimeMs = v;
        return this;
    }

    public TxnOffsetCommitResponseData setTopics(List<TxnOffsetCommitResponseTopic> v) {
        this.topics = v;
        return this;
    }

    static {
        SCHEMA_2 = SCHEMA_1 = (SCHEMA_0 = new Schema(new Field("throttle_time_ms", Type.INT32, "The duration in milliseconds for which the request was throttled due to a quota violation, or zero if the request did not violate any quota."), new Field("topics", new ArrayOf(TxnOffsetCommitResponseTopic.SCHEMA_0), "The responses for each topic.")));
        SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2};
    }

    public static class TxnOffsetCommitResponsePartition
    implements Message {
        private int partitionIndex;
        private short errorCode;
        public static final Schema SCHEMA_0;
        public static final Schema SCHEMA_1;
        public static final Schema SCHEMA_2;
        public static final Schema[] SCHEMAS;

        public TxnOffsetCommitResponsePartition(Readable readable, short version) {
            this.read(readable, version);
        }

        public TxnOffsetCommitResponsePartition(Struct struct, short version) {
            this.fromStruct(struct, version);
        }

        public TxnOffsetCommitResponsePartition() {
            this.partitionIndex = 0;
            this.errorCode = 0;
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 2;
        }

        @Override
        public void read(Readable readable, short version) {
            this.partitionIndex = readable.readInt();
            this.errorCode = readable.readShort();
        }

        @Override
        public void write(Writable writable, short version) {
            writable.writeInt(this.partitionIndex);
            writable.writeShort(this.errorCode);
        }

        @Override
        public void fromStruct(Struct struct, short version) {
            this.partitionIndex = struct.getInt("partition_index");
            this.errorCode = struct.getShort("error_code");
        }

        @Override
        public Struct toStruct(short version) {
            Struct struct = new Struct(SCHEMAS[version]);
            struct.set("partition_index", (Object)this.partitionIndex);
            struct.set("error_code", (Object)this.errorCode);
            return struct;
        }

        @Override
        public int size(short version) {
            int size = 0;
            size += 4;
            return size += 2;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof TxnOffsetCommitResponsePartition)) {
                return false;
            }
            TxnOffsetCommitResponsePartition other = (TxnOffsetCommitResponsePartition)obj;
            if (this.partitionIndex != other.partitionIndex) {
                return false;
            }
            return this.errorCode == other.errorCode;
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + this.partitionIndex;
            hashCode = 31 * hashCode + this.errorCode;
            return hashCode;
        }

        public String toString() {
            return "TxnOffsetCommitResponsePartition(partitionIndex=" + this.partitionIndex + ", errorCode=" + this.errorCode + ")";
        }

        public int partitionIndex() {
            return this.partitionIndex;
        }

        public short errorCode() {
            return this.errorCode;
        }

        public TxnOffsetCommitResponsePartition setPartitionIndex(int v) {
            this.partitionIndex = v;
            return this;
        }

        public TxnOffsetCommitResponsePartition setErrorCode(short v) {
            this.errorCode = v;
            return this;
        }

        static {
            SCHEMA_2 = SCHEMA_1 = (SCHEMA_0 = new Schema(new Field("partition_index", Type.INT32, "The partitition index."), new Field("error_code", Type.INT16, "The error code, or 0 if there was no error.")));
            SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2};
        }
    }

    public static class TxnOffsetCommitResponseTopic
    implements Message {
        private String name;
        private List<TxnOffsetCommitResponsePartition> partitions;
        public static final Schema SCHEMA_0;
        public static final Schema SCHEMA_1;
        public static final Schema SCHEMA_2;
        public static final Schema[] SCHEMAS;

        public TxnOffsetCommitResponseTopic(Readable readable, short version) {
            this.partitions = new ArrayList<TxnOffsetCommitResponsePartition>();
            this.read(readable, version);
        }

        public TxnOffsetCommitResponseTopic(Struct struct, short version) {
            this.partitions = new ArrayList<TxnOffsetCommitResponsePartition>();
            this.fromStruct(struct, version);
        }

        public TxnOffsetCommitResponseTopic() {
            this.name = "";
            this.partitions = new ArrayList<TxnOffsetCommitResponsePartition>();
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 2;
        }

        @Override
        public void read(Readable readable, short version) {
            this.name = readable.readNullableString();
            int arrayLength = readable.readInt();
            if (arrayLength < 0) {
                this.partitions.clear();
            } else {
                this.partitions.clear();
                for (int i = 0; i < arrayLength; ++i) {
                    this.partitions.add(new TxnOffsetCommitResponsePartition(readable, version));
                }
            }
        }

        @Override
        public void write(Writable writable, short version) {
            writable.writeString(this.name);
            writable.writeInt(this.partitions.size());
            for (TxnOffsetCommitResponsePartition element : this.partitions) {
                element.write(writable, version);
            }
        }

        @Override
        public void fromStruct(Struct struct, short version) {
            this.name = struct.getString("name");
            Object[] nestedObjects = struct.getArray("partitions");
            this.partitions = new ArrayList<TxnOffsetCommitResponsePartition>(nestedObjects.length);
            for (Object nestedObject : nestedObjects) {
                this.partitions.add(new TxnOffsetCommitResponsePartition((Struct)nestedObject, version));
            }
        }

        @Override
        public Struct toStruct(short version) {
            Struct struct = new Struct(SCHEMAS[version]);
            struct.set("name", (Object)this.name);
            Struct[] nestedObjects = new Struct[this.partitions.size()];
            int i = 0;
            for (TxnOffsetCommitResponsePartition element : this.partitions) {
                nestedObjects[i++] = element.toStruct(version);
            }
            struct.set("partitions", (Object)nestedObjects);
            return struct;
        }

        @Override
        public int size(short version) {
            int size = 0;
            size += 2;
            size += MessageUtil.serializedUtf8Length(this.name);
            size += 4;
            for (TxnOffsetCommitResponsePartition element : this.partitions) {
                size += element.size(version);
            }
            return size;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof TxnOffsetCommitResponseTopic)) {
                return false;
            }
            TxnOffsetCommitResponseTopic other = (TxnOffsetCommitResponseTopic)obj;
            if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                return false;
            }
            return !(this.partitions == null ? other.partitions != null : !this.partitions.equals(other.partitions));
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + (this.name == null ? 0 : this.name.hashCode());
            hashCode = 31 * hashCode + (this.partitions == null ? 0 : this.partitions.hashCode());
            return hashCode;
        }

        public String toString() {
            return "TxnOffsetCommitResponseTopic(name='" + this.name + "', partitions=" + MessageUtil.deepToString(this.partitions.iterator()) + ")";
        }

        public String name() {
            return this.name;
        }

        public List<TxnOffsetCommitResponsePartition> partitions() {
            return this.partitions;
        }

        public TxnOffsetCommitResponseTopic setName(String v) {
            this.name = v;
            return this;
        }

        public TxnOffsetCommitResponseTopic setPartitions(List<TxnOffsetCommitResponsePartition> v) {
            this.partitions = v;
            return this;
        }

        static {
            SCHEMA_2 = SCHEMA_1 = (SCHEMA_0 = new Schema(new Field("name", Type.STRING, "The topic name."), new Field("partitions", new ArrayOf(TxnOffsetCommitResponsePartition.SCHEMA_0), "The responses for each partition in the topic.")));
            SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2};
        }
    }
}

