/*
 * Decompiled with CFR 0.152.
 */
package shaded.alink.kafka.org.apache.kafka.common.message;

import java.util.ArrayList;
import java.util.List;
import shaded.alink.kafka.org.apache.kafka.common.protocol.ApiMessage;
import shaded.alink.kafka.org.apache.kafka.common.protocol.MessageUtil;
import shaded.alink.kafka.org.apache.kafka.common.protocol.Readable;
import shaded.alink.kafka.org.apache.kafka.common.protocol.Writable;
import shaded.alink.kafka.org.apache.kafka.common.protocol.types.ArrayOf;
import shaded.alink.kafka.org.apache.kafka.common.protocol.types.Field;
import shaded.alink.kafka.org.apache.kafka.common.protocol.types.Schema;
import shaded.alink.kafka.org.apache.kafka.common.protocol.types.Struct;
import shaded.alink.kafka.org.apache.kafka.common.protocol.types.Type;

public class DeleteTopicsRequestData
implements ApiMessage {
    private List<String> topicNames = new ArrayList<String>();
    private int timeoutMs;
    public static final Schema SCHEMA_0;
    public static final Schema SCHEMA_1;
    public static final Schema SCHEMA_2;
    public static final Schema SCHEMA_3;
    public static final Schema[] SCHEMAS;

    public DeleteTopicsRequestData(Readable readable, short version) {
        this.read(readable, version);
    }

    public DeleteTopicsRequestData(Struct struct, short version) {
        this.fromStruct(struct, version);
    }

    public DeleteTopicsRequestData() {
        this.timeoutMs = 0;
    }

    @Override
    public short apiKey() {
        return 20;
    }

    @Override
    public short lowestSupportedVersion() {
        return 0;
    }

    @Override
    public short highestSupportedVersion() {
        return 3;
    }

    @Override
    public void read(Readable readable, short version) {
        int arrayLength = readable.readInt();
        if (arrayLength < 0) {
            this.topicNames.clear();
        } else {
            this.topicNames.clear();
            for (int i = 0; i < arrayLength; ++i) {
                this.topicNames.add(readable.readNullableString());
            }
        }
        this.timeoutMs = readable.readInt();
    }

    @Override
    public void write(Writable writable, short version) {
        writable.writeInt(this.topicNames.size());
        for (String element : this.topicNames) {
            writable.writeString(element);
        }
        writable.writeInt(this.timeoutMs);
    }

    @Override
    public void fromStruct(Struct struct, short version) {
        Object[] nestedObjects = struct.getArray("topic_names");
        this.topicNames = new ArrayList<String>(nestedObjects.length);
        for (Object nestedObject : nestedObjects) {
            this.topicNames.add((String)nestedObject);
        }
        this.timeoutMs = struct.getInt("timeout_ms");
    }

    @Override
    public Struct toStruct(short version) {
        Struct struct = new Struct(SCHEMAS[version]);
        String[] nestedObjects = new String[this.topicNames.size()];
        int i = 0;
        for (String element : this.topicNames) {
            nestedObjects[i++] = element;
        }
        struct.set("topic_names", (Object)nestedObjects);
        struct.set("timeout_ms", (Object)this.timeoutMs);
        return struct;
    }

    @Override
    public int size(short version) {
        int size = 0;
        size += 4;
        for (String element : this.topicNames) {
            size += 2;
            size += MessageUtil.serializedUtf8Length(element);
        }
        return size += 4;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DeleteTopicsRequestData)) {
            return false;
        }
        DeleteTopicsRequestData other = (DeleteTopicsRequestData)obj;
        if (this.topicNames == null ? other.topicNames != null : !this.topicNames.equals(other.topicNames)) {
            return false;
        }
        return this.timeoutMs == other.timeoutMs;
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + (this.topicNames == null ? 0 : this.topicNames.hashCode());
        hashCode = 31 * hashCode + this.timeoutMs;
        return hashCode;
    }

    public String toString() {
        return "DeleteTopicsRequestData(topicNames=" + MessageUtil.deepToString(this.topicNames.iterator()) + ", timeoutMs=" + this.timeoutMs + ")";
    }

    public List<String> topicNames() {
        return this.topicNames;
    }

    public int timeoutMs() {
        return this.timeoutMs;
    }

    public DeleteTopicsRequestData setTopicNames(List<String> v) {
        this.topicNames = v;
        return this;
    }

    public DeleteTopicsRequestData setTimeoutMs(int v) {
        this.timeoutMs = v;
        return this;
    }

    static {
        SCHEMA_3 = SCHEMA_2 = (SCHEMA_1 = (SCHEMA_0 = new Schema(new Field("topic_names", new ArrayOf(Type.STRING), "The names of the topics to delete"), new Field("timeout_ms", Type.INT32, "The length of time in milliseconds to wait for the deletions to complete."))));
        SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2, SCHEMA_3};
    }
}

