/*
 * Decompiled with CFR 0.152.
 */
package shaded.alink.kafka.org.apache.flink.streaming.connectors.kafka;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.serialization.DeserializationSchema;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.sources.DefinedFieldMapping;
import org.apache.flink.table.sources.DefinedProctimeAttribute;
import org.apache.flink.table.sources.DefinedRowtimeAttributes;
import org.apache.flink.table.sources.RowtimeAttributeDescriptor;
import org.apache.flink.table.sources.StreamTableSource;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.LogicalTypeRoot;
import org.apache.flink.table.utils.TableConnectorUtils;
import org.apache.flink.table.utils.TableSchemaUtils;
import org.apache.flink.types.Row;
import org.apache.flink.util.Preconditions;
import shaded.alink.kafka.org.apache.flink.streaming.connectors.kafka.FlinkKafkaConsumerBase;
import shaded.alink.kafka.org.apache.flink.streaming.connectors.kafka.config.StartupMode;
import shaded.alink.kafka.org.apache.flink.streaming.connectors.kafka.internals.KafkaTopicPartition;

@Internal
public abstract class KafkaTableSourceBase
implements StreamTableSource<Row>,
DefinedProctimeAttribute,
DefinedRowtimeAttributes,
DefinedFieldMapping {
    private final TableSchema schema;
    private final Optional<String> proctimeAttribute;
    private final List<RowtimeAttributeDescriptor> rowtimeAttributeDescriptors;
    private final Optional<Map<String, String>> fieldMapping;
    private final String topic;
    private final Properties properties;
    private final DeserializationSchema<Row> deserializationSchema;
    private final StartupMode startupMode;
    private final Map<KafkaTopicPartition, Long> specificStartupOffsets;

    protected KafkaTableSourceBase(TableSchema schema, Optional<String> proctimeAttribute, List<RowtimeAttributeDescriptor> rowtimeAttributeDescriptors, Optional<Map<String, String>> fieldMapping, String topic, Properties properties, DeserializationSchema<Row> deserializationSchema, StartupMode startupMode, Map<KafkaTopicPartition, Long> specificStartupOffsets) {
        this.schema = TableSchemaUtils.checkNoGeneratedColumns((TableSchema)schema);
        this.proctimeAttribute = this.validateProctimeAttribute(proctimeAttribute);
        this.rowtimeAttributeDescriptors = this.validateRowtimeAttributeDescriptors(rowtimeAttributeDescriptors);
        this.fieldMapping = fieldMapping;
        this.topic = (String)Preconditions.checkNotNull((Object)topic, (String)"Topic must not be null.");
        this.properties = (Properties)Preconditions.checkNotNull((Object)properties, (String)"Properties must not be null.");
        this.deserializationSchema = (DeserializationSchema)Preconditions.checkNotNull(deserializationSchema, (String)"Deserialization schema must not be null.");
        this.startupMode = (StartupMode)((Object)Preconditions.checkNotNull((Object)((Object)startupMode), (String)"Startup mode must not be null."));
        this.specificStartupOffsets = (Map)Preconditions.checkNotNull(specificStartupOffsets, (String)"Specific offsets must not be null.");
    }

    protected KafkaTableSourceBase(TableSchema schema, String topic, Properties properties, DeserializationSchema<Row> deserializationSchema) {
        this(schema, Optional.empty(), Collections.emptyList(), Optional.empty(), topic, properties, deserializationSchema, StartupMode.GROUP_OFFSETS, Collections.emptyMap());
    }

    public DataStream<Row> getDataStream(StreamExecutionEnvironment env) {
        DeserializationSchema<Row> deserializationSchema = this.getDeserializationSchema();
        FlinkKafkaConsumerBase<Row> kafkaConsumer = this.getKafkaConsumer(this.topic, this.properties, deserializationSchema);
        return env.addSource(kafkaConsumer).name(this.explainSource());
    }

    public TypeInformation<Row> getReturnType() {
        return this.deserializationSchema.getProducedType();
    }

    public TableSchema getTableSchema() {
        return this.schema;
    }

    public String getProctimeAttribute() {
        return this.proctimeAttribute.orElse(null);
    }

    public List<RowtimeAttributeDescriptor> getRowtimeAttributeDescriptors() {
        return this.rowtimeAttributeDescriptors;
    }

    public Map<String, String> getFieldMapping() {
        return this.fieldMapping.orElse(null);
    }

    public String explainSource() {
        return TableConnectorUtils.generateRuntimeName(this.getClass(), (String[])this.schema.getFieldNames());
    }

    public Properties getProperties() {
        return this.properties;
    }

    public DeserializationSchema<Row> getDeserializationSchema() {
        return this.deserializationSchema;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KafkaTableSourceBase that = (KafkaTableSourceBase)o;
        return Objects.equals(this.schema, that.schema) && Objects.equals(this.proctimeAttribute, that.proctimeAttribute) && Objects.equals(this.rowtimeAttributeDescriptors, that.rowtimeAttributeDescriptors) && Objects.equals(this.fieldMapping, that.fieldMapping) && Objects.equals(this.topic, that.topic) && Objects.equals(this.properties, that.properties) && Objects.equals(this.deserializationSchema, that.deserializationSchema) && this.startupMode == that.startupMode && Objects.equals(this.specificStartupOffsets, that.specificStartupOffsets);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.schema, this.proctimeAttribute, this.rowtimeAttributeDescriptors, this.fieldMapping, this.topic, this.properties, this.deserializationSchema, this.startupMode, this.specificStartupOffsets});
    }

    protected FlinkKafkaConsumerBase<Row> getKafkaConsumer(String topic, Properties properties, DeserializationSchema<Row> deserializationSchema) {
        FlinkKafkaConsumerBase<Row> kafkaConsumer = this.createKafkaConsumer(topic, properties, deserializationSchema);
        switch (this.startupMode) {
            case EARLIEST: {
                kafkaConsumer.setStartFromEarliest();
                break;
            }
            case LATEST: {
                kafkaConsumer.setStartFromLatest();
                break;
            }
            case GROUP_OFFSETS: {
                kafkaConsumer.setStartFromGroupOffsets();
                break;
            }
            case SPECIFIC_OFFSETS: {
                kafkaConsumer.setStartFromSpecificOffsets(this.specificStartupOffsets);
            }
        }
        return kafkaConsumer;
    }

    private Optional<String> validateProctimeAttribute(Optional<String> proctimeAttribute) {
        return proctimeAttribute.map(attribute -> {
            Optional tpe = this.schema.getFieldDataType(attribute);
            if (!tpe.isPresent()) {
                throw new ValidationException("Processing time attribute '" + attribute + "' is not present in TableSchema.");
            }
            if (((DataType)tpe.get()).getLogicalType().getTypeRoot() != LogicalTypeRoot.TIMESTAMP_WITHOUT_TIME_ZONE) {
                throw new ValidationException("Processing time attribute '" + attribute + "' is not of type TIMESTAMP.");
            }
            return attribute;
        });
    }

    private List<RowtimeAttributeDescriptor> validateRowtimeAttributeDescriptors(List<RowtimeAttributeDescriptor> rowtimeAttributeDescriptors) {
        Preconditions.checkNotNull(rowtimeAttributeDescriptors, (String)"List of rowtime attributes must not be null.");
        for (RowtimeAttributeDescriptor desc : rowtimeAttributeDescriptors) {
            String rowtimeAttribute = desc.getAttributeName();
            Optional tpe = this.schema.getFieldDataType(rowtimeAttribute);
            if (!tpe.isPresent()) {
                throw new ValidationException("Rowtime attribute '" + rowtimeAttribute + "' is not present in TableSchema.");
            }
            if (((DataType)tpe.get()).getLogicalType().getTypeRoot() == LogicalTypeRoot.TIMESTAMP_WITHOUT_TIME_ZONE) continue;
            throw new ValidationException("Rowtime attribute '" + rowtimeAttribute + "' is not of type TIMESTAMP.");
        }
        return rowtimeAttributeDescriptors;
    }

    protected abstract FlinkKafkaConsumerBase<Row> createKafkaConsumer(String var1, Properties var2, DeserializationSchema<Row> var3);
}

