/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.descriptors;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.descriptors.ConnectorDescriptorValidator;
import org.apache.flink.table.descriptors.DescriptorProperties;
import shaded.alink.kafka010.org.apache.flink.streaming.connectors.kafka.config.StartupMode;

@Internal
public class KafkaValidator
extends ConnectorDescriptorValidator {
    public static final String CONNECTOR_TYPE_VALUE_KAFKA = "kafka";
    public static final String CONNECTOR_VERSION_VALUE_08 = "0.8";
    public static final String CONNECTOR_VERSION_VALUE_09 = "0.9";
    public static final String CONNECTOR_VERSION_VALUE_010 = "0.10";
    public static final String CONNECTOR_VERSION_VALUE_011 = "0.11";
    public static final String CONNECTOR_VERSION_VALUE_UNIVERSAL = "universal";
    public static final String CONNECTOR_TOPIC = "connector.topic";
    public static final String CONNECTOR_STARTUP_MODE = "connector.startup-mode";
    public static final String CONNECTOR_STARTUP_MODE_VALUE_EARLIEST = "earliest-offset";
    public static final String CONNECTOR_STARTUP_MODE_VALUE_LATEST = "latest-offset";
    public static final String CONNECTOR_STARTUP_MODE_VALUE_GROUP_OFFSETS = "group-offsets";
    public static final String CONNECTOR_STARTUP_MODE_VALUE_SPECIFIC_OFFSETS = "specific-offsets";
    public static final String CONNECTOR_SPECIFIC_OFFSETS = "connector.specific-offsets";
    public static final String CONNECTOR_SPECIFIC_OFFSETS_PARTITION = "partition";
    public static final String CONNECTOR_SPECIFIC_OFFSETS_OFFSET = "offset";
    public static final String CONNECTOR_PROPERTIES = "connector.properties";
    public static final String CONNECTOR_PROPERTIES_ZOOKEEPER_CONNECT = "connector.properties.zookeeper.connect";
    public static final String CONNECTOR_PROPERTIES_BOOTSTRAP_SERVER = "connector.properties.bootstrap.servers";
    public static final String CONNECTOR_PROPERTIES_GROUP_ID = "connector.properties.group.id";
    public static final String CONNECTOR_PROPERTIES_KEY = "key";
    public static final String CONNECTOR_PROPERTIES_VALUE = "value";
    public static final String CONNECTOR_SINK_PARTITIONER = "connector.sink-partitioner";
    public static final String CONNECTOR_SINK_PARTITIONER_VALUE_FIXED = "fixed";
    public static final String CONNECTOR_SINK_PARTITIONER_VALUE_ROUND_ROBIN = "round-robin";
    public static final String CONNECTOR_SINK_PARTITIONER_VALUE_CUSTOM = "custom";
    public static final String CONNECTOR_SINK_PARTITIONER_CLASS = "connector.sink-partitioner-class";

    public void validate(DescriptorProperties properties) {
        super.validate(properties);
        properties.validateEnumValues("update-mode", true, Collections.singletonList("append"));
        properties.validateValue("connector.type", CONNECTOR_TYPE_VALUE_KAFKA, false);
        properties.validateString(CONNECTOR_TOPIC, false, 1, Integer.MAX_VALUE);
        this.validateStartupMode(properties);
        this.validateKafkaProperties(properties);
        this.validateSinkPartitioner(properties);
    }

    private void validateStartupMode(DescriptorProperties properties) {
        HashMap<String, Consumer<String>> specificOffsetValidators = new HashMap<String, Consumer<String>>();
        specificOffsetValidators.put(CONNECTOR_SPECIFIC_OFFSETS_PARTITION, key -> properties.validateInt(key, false, 0, Integer.MAX_VALUE));
        specificOffsetValidators.put(CONNECTOR_SPECIFIC_OFFSETS_OFFSET, key -> properties.validateLong(key, false, 0L, Long.MAX_VALUE));
        HashMap<String, Consumer<String>> startupModeValidation = new HashMap<String, Consumer<String>>();
        startupModeValidation.put(CONNECTOR_STARTUP_MODE_VALUE_GROUP_OFFSETS, DescriptorProperties.noValidation());
        startupModeValidation.put(CONNECTOR_STARTUP_MODE_VALUE_EARLIEST, DescriptorProperties.noValidation());
        startupModeValidation.put(CONNECTOR_STARTUP_MODE_VALUE_LATEST, DescriptorProperties.noValidation());
        if (properties.containsKey(CONNECTOR_SPECIFIC_OFFSETS)) {
            KafkaValidator.validateAndParseSpecificOffsetsString(properties);
            startupModeValidation.put(CONNECTOR_STARTUP_MODE_VALUE_SPECIFIC_OFFSETS, DescriptorProperties.noValidation());
        } else {
            startupModeValidation.put(CONNECTOR_STARTUP_MODE_VALUE_SPECIFIC_OFFSETS, key -> properties.validateFixedIndexedProperties(CONNECTOR_SPECIFIC_OFFSETS, false, specificOffsetValidators));
        }
        properties.validateEnum(CONNECTOR_STARTUP_MODE, true, startupModeValidation);
    }

    private void validateKafkaProperties(DescriptorProperties properties) {
        if (properties.containsKey(CONNECTOR_PROPERTIES_ZOOKEEPER_CONNECT) || properties.containsKey(CONNECTOR_PROPERTIES_BOOTSTRAP_SERVER) || properties.containsKey(CONNECTOR_PROPERTIES_GROUP_ID)) {
            properties.validateString(CONNECTOR_PROPERTIES_ZOOKEEPER_CONNECT, false);
            properties.validateString(CONNECTOR_PROPERTIES_BOOTSTRAP_SERVER, false);
            properties.validateString(CONNECTOR_PROPERTIES_GROUP_ID, true);
        } else {
            HashMap<String, Consumer<String>> propertyValidators = new HashMap<String, Consumer<String>>();
            propertyValidators.put(CONNECTOR_PROPERTIES_KEY, key -> properties.validateString(key, false, 1));
            propertyValidators.put(CONNECTOR_PROPERTIES_VALUE, key -> properties.validateString(key, false, 0));
            properties.validateFixedIndexedProperties(CONNECTOR_PROPERTIES, true, propertyValidators);
        }
    }

    private void validateSinkPartitioner(DescriptorProperties properties) {
        HashMap<String, Consumer<String>> sinkPartitionerValidators = new HashMap<String, Consumer<String>>();
        sinkPartitionerValidators.put(CONNECTOR_SINK_PARTITIONER_VALUE_FIXED, DescriptorProperties.noValidation());
        sinkPartitionerValidators.put(CONNECTOR_SINK_PARTITIONER_VALUE_ROUND_ROBIN, DescriptorProperties.noValidation());
        sinkPartitionerValidators.put(CONNECTOR_SINK_PARTITIONER_VALUE_CUSTOM, key -> properties.validateString(CONNECTOR_SINK_PARTITIONER_CLASS, false, 1));
        properties.validateEnum(CONNECTOR_SINK_PARTITIONER, true, sinkPartitionerValidators);
    }

    public static String normalizeStartupMode(StartupMode startupMode) {
        switch (startupMode) {
            case EARLIEST: {
                return CONNECTOR_STARTUP_MODE_VALUE_EARLIEST;
            }
            case LATEST: {
                return CONNECTOR_STARTUP_MODE_VALUE_LATEST;
            }
            case GROUP_OFFSETS: {
                return CONNECTOR_STARTUP_MODE_VALUE_GROUP_OFFSETS;
            }
            case SPECIFIC_OFFSETS: {
                return CONNECTOR_STARTUP_MODE_VALUE_SPECIFIC_OFFSETS;
            }
        }
        throw new IllegalArgumentException("Invalid startup mode.");
    }

    public static Map<Integer, Long> validateAndParseSpecificOffsetsString(DescriptorProperties descriptorProperties) {
        HashMap<Integer, Long> offsetMap = new HashMap<Integer, Long>();
        descriptorProperties.validateString(CONNECTOR_SPECIFIC_OFFSETS, false, 1);
        String parseSpecificOffsetsStr = descriptorProperties.getString(CONNECTOR_SPECIFIC_OFFSETS);
        String[] pairs = parseSpecificOffsetsStr.split(";");
        String validationExceptionMessage = "Invalid properties 'connector.specific-offsets' should follow the format 'partition:0,offset:42;partition:1,offset:300', but is '" + parseSpecificOffsetsStr + "'.";
        if (pairs.length == 0) {
            throw new ValidationException(validationExceptionMessage);
        }
        for (String pair : pairs) {
            if (null == pair || pair.length() == 0 || !pair.contains(",")) {
                throw new ValidationException(validationExceptionMessage);
            }
            String[] kv = pair.split(",");
            if (kv.length != 2 || !kv[0].startsWith("partition:") || !kv[1].startsWith("offset:")) {
                throw new ValidationException(validationExceptionMessage);
            }
            String partitionValue = kv[0].substring(kv[0].indexOf(":") + 1);
            String offsetValue = kv[1].substring(kv[1].indexOf(":") + 1);
            try {
                Integer partition = Integer.valueOf(partitionValue);
                Long offset = Long.valueOf(offsetValue);
                offsetMap.put(partition, offset);
            }
            catch (NumberFormatException e) {
                throw new ValidationException(validationExceptionMessage, (Throwable)e);
            }
        }
        return offsetMap;
    }

    public static boolean hasConciseKafkaProperties(DescriptorProperties descriptorProperties) {
        return descriptorProperties.containsKey(CONNECTOR_PROPERTIES_ZOOKEEPER_CONNECT) || descriptorProperties.containsKey(CONNECTOR_PROPERTIES_BOOTSTRAP_SERVER) || descriptorProperties.containsKey(CONNECTOR_PROPERTIES_GROUP_ID);
    }
}

