/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.alink.operator.stream.sink;

import com.alibaba.alink.operator.common.io.kafka.BaseKafkaSinkBuilder;
import com.alibaba.alink.operator.stream.StreamOperator;
import com.alibaba.alink.operator.stream.sink.BaseSinkStreamOp;
import com.alibaba.alink.params.io.KafkaSinkParams;
import com.alibaba.alink.params.io.shared_params.HasDataFormat;
import java.util.Properties;
import org.apache.flink.ml.api.misc.param.Params;
import org.apache.flink.streaming.api.functions.sink.RichSinkFunction;
import org.apache.flink.types.Row;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.StringUtils;

public abstract class BaseKafkaSinkStreamOp<T extends BaseKafkaSinkStreamOp<T>>
extends BaseSinkStreamOp<T> {
    public BaseKafkaSinkStreamOp(String nameSrcSnk, Params params) {
        super(nameSrcSnk, params);
    }

    protected abstract BaseKafkaSinkBuilder getKafkaSinkBuilder();

    public T sinkFrom(StreamOperator in) {
        String topic = (String)this.getParams().get(KafkaSinkParams.TOPIC);
        String fieldDelimiter = (String)this.getParams().get(KafkaSinkParams.FIELD_DELIMITER);
        HasDataFormat.DataFormat dataFormat = (HasDataFormat.DataFormat)this.getParams().get(KafkaSinkParams.DATA_FORMAT);
        String bootstrapServer = (String)this.getParams().get(KafkaSinkParams.BOOTSTRAP_SERVERS);
        String properties = (String)this.getParams().get(KafkaSinkParams.PROPERTIES);
        Properties props = new Properties();
        props.setProperty("bootstrap.servers", bootstrapServer);
        if (!StringUtils.isNullOrWhitespaceOnly((String)properties)) {
            String[] kvPairs;
            for (String kvPair : kvPairs = properties.split(",")) {
                int pos = kvPair.indexOf(61);
                Preconditions.checkArgument((pos >= 0 ? 1 : 0) != 0, (Object)"Invalid properties format, should be \"k1=v1,k2=v2,...\"");
                String key = kvPair.substring(0, pos);
                String value = kvPair.substring(pos + 1);
                props.setProperty(key, value);
            }
        }
        BaseKafkaSinkBuilder builder = this.getKafkaSinkBuilder();
        builder.setTopic(topic);
        builder.setFieldDelimiter(fieldDelimiter);
        builder.setFieldNames(in.getColNames());
        builder.setFieldTypes(in.getColTypes());
        builder.setFormat(dataFormat);
        builder.setProperties(props);
        RichSinkFunction<Row> sink = builder.build();
        in.getDataStream().addSink(sink).name("kafka");
        return (T)((Object)this);
    }
}

