"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.RosOutput = void 0;
const ros_element_1 = require("./ros-element");
class RosOutput extends ros_element_1.RosElement {
    /**
     * Creates an RosOutput value for this stack.
     * @param scope The parent construct.
     * @param props RosOutput properties.
     */
    constructor(scope, id, props) {
        super(scope, id);
        if (props.value === undefined) {
            throw new Error(`Missing value for ROS output at path "${this.node.path}"`);
        }
        this._description = props.description;
        this._value = props.value;
        this._condition = props.condition;
        this._export = props.exportName;
    }
    /**
     * @internal
     */
    _toRosTemplate() {
        return {
            Outputs: {
                [this.logicalId]: {
                    Description: this._description,
                    Value: this._value,
                    Export: this._export != null ? { Name: this._export } : undefined,
                    Condition: this._condition ? this._condition.logicalId : undefined,
                },
            },
        };
    }
    addCondition(condition) {
        this._condition = condition;
    }
}
exports.RosOutput = RosOutput;
//# sourceMappingURL=data:application/json;base64,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