# 🛠️ sima-cli – SiMa Developer Portal CLI Tool

`sima-cli` is a command-line interface (CLI) utility designed to interact with the SiMa Developer Portal. It supports downloading models and apps from the Model/App Zoo, performing firmware updates, and authenticating against internal or external environments.

---

## 📦 Installation

```bash
pip install sima-cli
```

---

## 🚀 Getting Started

```bash
sima-cli --help
```

### Global Option

- `--internal`: Use internal Artifactory resources (can also be set via `SIMA_CLI_INTERNAL=1`).

Environment detection output will appear like:

```
🔧 Environment: dev (sandbox) | Internal: True
```

If external mode is detected and not supported:

```
external environment is not supported yet..
```

---

## 🔐 Authentication

```bash
sima-cli login
```

Authenticates with the SiMa Developer Portal. Internal or external login is selected based on context.

---

## 📥 Download Resources

```bash
sima-cli download <URL> [-d DEST]
```

- Downloads a single file or an entire folder from the provided URL.
- Options:
  - `-d`, `--dest`: Destination folder (default is current directory).

---

## 🔧 Firmware Update

```bash
sima-cli update <version_or_url> [--ip IP] [--board BOARD] [--passwd PASSWORD]
```

- Updates firmware either locally or over the network.
- Positional:
  - `<version_or_url>`: Version string (e.g. `1.5.0`) or direct URL.
- Options:
  - `--ip`: IP address of remote device (for network update).
  - `--board`: Board type, one of `davinci`, `modalix` (default: `davinci`).
  - `--passwd`: SSH password for remote board (default: `edgeai`).

---

## 🧠 Model Zoo

### List Models

```bash
sima-cli model-zoo list [--ver VERSION]
```

- Lists available models for a given SDK version.

### Get Model

```bash
sima-cli model-zoo get <MODEL_NAME> [--ver VERSION]
```

- Downloads the specified model.

---

## 📱 App Zoo

### List Apps

```bash
sima-cli app-zoo list [--ver VERSION]
```

- Lists available apps for a given SDK version.

### Get App

```bash
sima-cli app-zoo get <APP_NAME> [--ver VERSION]
```

- Downloads the specified app.

---

## 🌍 Environment Variable Support

Instead of using `--internal` flag every time, you can set:

```bash
export SIMA_CLI_INTERNAL=1
```

---

## 🧪 Examples

### Authenticate Internally

```bash
sima-cli --internal login
```


### Firmware Update on Davinci (MLSOC Gen 1) Board

```bash
sima-cli update 1.6.0_master_B1611 --ip 192.168.1.20
```

---

## 🧩 Requirements

- Python 3.8+
- Internal network access if using `--internal` features

---

## 📞 Support

Please reach out to **SiMa Support** (support@sima.ai) if you encounter issues with downloads or updates.

---
