use ndarray::{Array1, ArrayView2, Axis};

pub const EPS: f32 = 1e-6;
pub const EPS64: f64 = 1e-12;

pub fn norm_sq_batched(x: &ArrayView2<f32>) -> Array1<f32> {
    x.map_axis(Axis(1), |row| row.mapv(|a| a.powi(2)).sum())
}

pub fn dot_batched(x: &ArrayView2<f32>, y: &ArrayView2<f32>) -> Array1<f32> {
    (x * y).sum_axis(Axis(1))
}

pub fn norm_sq_batched_f64(x: &ArrayView2<f64>) -> Array1<f64> {
    x.map_axis(Axis(1), |row| row.mapv(|a| a * a).sum())
}

pub fn dot_batched_f64(x: &ArrayView2<f64>, y: &ArrayView2<f64>) -> Array1<f64> {
    (x * y).sum_axis(Axis(1))
}
