import time
from random import randint

from mona_sdk import Client, MonaSingleMessage

# Es monitor test
client_id = "e8018061-0559-4b22-b041-f10ef5848cd6"
secret_key = "9df5eefb-de6d-4529-b79a-60b398353449"

CONTEXT_CLASSES = [
    "smadar_test1",
    # "SMADAR_TEST_IN_CONFIG_SAMPLED"
    # "smadar_test3",
    # "smadar_test4",
    # "smadar_test5",
    # "smadar_test6"
]
NUMBER_OF_MESSAGES_PER_CONTEXT_CLASS = 10


def random_with_N_digits(n):
    range_start = 10 ** (n - 1)
    range_end = (10 ** n) - 1
    return randint(range_start, range_end)


# Let's have 4 context classes - the 4th will take the default value (0.7).
my_mona_client = Client(
    api_key=client_id,
    secret=secret_key,
    user_id="ef3a7c1a-cf94-489b-8c69-5075136003f2",
    # should_use_authentication=False,
    # should_use_ssl=False,
    # override_rest_api_host="rest-api host address",
    # sampling_config_name="smadar_neti_test",
    raise_export_exceptions=True,
)


def get_random_from_0_to_90():
    ret = random_with_N_digits(2)
    return ret % 90


def get_random_from_0_to_minus90():
    ret = random_with_N_digits(2)
    return -(ret % 90)


total_requests_time = 0

for context_class in CONTEXT_CLASSES:
    messages = []
    for i in range(NUMBER_OF_MESSAGES_PER_CONTEXT_CLASS):
        #messages.append(
        #   MonaSingleMessage(
        #       message={
        #           "geo_test_str": f"{get_random_from_0_to_minus90()}, {get_random_from_0_to_90()}"
        #       },
        #       contextClass="context_class_name",
        #       contextId=str(i),  # str(random_with_N_digits(10))
        #   )
        #)
        #messages.append(
        #   MonaSingleMessage(
        #       message={
        #           "geo_test_point_str": f"POINT ({get_random_from_0_to_minus90()} {get_random_from_0_to_90()})"
        #       },
        #       contextClass="context_class_name",
        #       contextId=str(i),  # str(random_with_N_digits(10))
        #   )
        #)
        #messages.append(
        #   MonaSingleMessage(
        #       message={
        #           "geo_test_with_lat_lan": {
        #               "lat": get_random_from_0_to_minus90(),
        #               "lon": get_random_from_0_to_90(),
        #           }
        #       },
        #       contextClass="context_class_name",
        #       contextId=str(i),  # str(random_with_N_digits(10))
        #   )
        #)
        #messages.append(
        #   MonaSingleMessage(
        #       message={
        #           "geo_test_with_array": [ get_random_from_0_to_minus90(), get_random_from_0_to_90() ]
        #       },
        #       contextClass="context_class_name",
        #       contextId=str(i),  # str(random_with_N_digits(10))
        #   )
        #)
        #messages.append(
        #   MonaSingleMessage(
        #       message={
        #           "geo_test_with_array": [ get_random_from_0_to_minus90(), get_random_from_0_to_90() ]
        #       },
        #       contextClass="context_class_name",
        #       contextId=str(i),  # str(random_with_N_digits(10))
        #   )
        #)

        messages.append(
           MonaSingleMessage(
               message={
                   "geo_test_with_wrong": f"POLYGON ((30 10, 30 10))"
               },
               contextClass="context_class_name",
               contextId=str(i),  # str(random_with_N_digits(10))
           )
        )
    print(f"sending context_class {context_class}")
    start_time = time.time()

    succeed_to_export = my_mona_client.export_batch(messages)
    print(succeed_to_export)
    total_requests_time += time.time() - start_time
    print(f"sent context_class {context_class}")
    # print(f"\n{context_class}: {succeed_to_export}")

print("--- %s seconds ---" % total_requests_time)
