# Number System Converter
[![forthebadge made-with-python](http://ForTheBadge.com/images/badges/made-with-python.svg)](https://www.python.org/)
[![MIT license](https://img.shields.io/badge/License-MIT-blue.svg)]()
[![Python 3.8+](https://img.shields.io/badge/python-3.7+-blue.svg)](https://www.python.org/downloads/release/python-370/)
[![Documentation Status](https://readthedocs.org/projects/ansicolortags/badge/?version=latest)](https://github.com/number-system/number-system/blob/master/README.md)
[![Maintenance](https://img.shields.io/badge/Maintained%3F-yes-green.svg)](https://github.com/number-system)


<span style="font-size:1.5em;">`numbersystem` is a Python 3.7+ package that simplifies the task of converts the decimal number in binary, octal, and hexadecimal or vice versa.
  
<span style="font-size:1.5em;">The number system or the numeral system is the system of naming or representing numbers. There are various types of number systems in maths like binary, decimal, etc.</span>


## Contents
- [Documentation](https://github.com/number-system/number-system/blob/master/README.md)
- [Types](##-Types)
- [Installation](#-installation)
- [Quick Start](#-quick-start)
- [Contribute](#-contribute)
- [Developers and Maintainers](#-developers-and-maintainers)
- [Copyright](#-copyright)


## Types
There are various types of the number system in mathematics. The four most common number system types are:
 1. Decimal number system (Base- 10)
 2. Binary number system (Base- 2)
 3. Octal number system (Base-8)
 4. Hexadecimal number system (Base- 16)


  #### Versions and Dependencies
  * Python 3.7+


## Installation
There are one ways to install the `numbersystem` package:

- Install `numbersystem` from PyPI (recommended):
```
pip install numbersystem
```


## Quick Start
To start converting with help of `numbersystem` . The following workflow can be used:

```
import numbersystem
numbersystem.decimalToBinary(25)
...............

```
For more information about how to use `numbersystem`, see our suggested **[template](https://github.com/number-system/number-system/blob/master/README.md)**.


## Contribute
We welcome all kinds of contributions that improve the performance of the currently published pacakge.

## Developers and Maintainers
* The developers began work to bring `numbersystem` into production in June 2020. `numbersystem` is actively maintained and there will be incremental improvements scheduled on a regular basis. The lead developers and maintainers are:

  * <b>Ritul Singh</b>, GitHub: [ritulsingh](https://github.com/ritulsingh)


* See the [Project Page](https://github.com/number-system) page to get in touch with the `numbersystem` team.

## Copyright
`numbersystem` is distributed under the MIT license. See [LICENSE](https://github.com/number-system/number-system/blob/master/LICENSE) for details.
