# This file is part of emzed (https://emzed.ethz.ch), a software toolbox for analysing
# LCMS data with Python.
#
# Copyright (C) 2020 ETH Zurich, SIS ID.
#
# This program is free software: you can redistribute it and/or modify it under the
# terms of the GNU General Public License as published by the Free Software Foundation,
# either version 3 of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful, but WITHOUT ANY
# WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
# PARTICULAR PURPOSE.  See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along with this
# program.  If not, see <http://www.gnu.org/licenses/>.


from PyQt5 import QtCore, QtGui

from ._choose_spectra_widget import Ui_ChooseSpectraWidget


class ChooseSpectraWidget(Ui_ChooseSpectraWidget):

    SELECTION_CHANGED = QtCore.pyqtSignal(list)

    def __init__(self, parent=None):
        super(ChooseSpectraWidget, self).__init__(parent)
        self._setup()

    def _setup(self):
        self._spectra.itemSelectionChanged.connect(self._selection_changed)
        self.setEnabled(False)

    def _selection_changed(self):
        row_indices = [item.row() for item in self._spectra.selectedIndexes()]
        self.SELECTION_CHANGED.emit(row_indices)

    def set_spectra(self, names):
        self._spectra.clear()
        for name in names:
            self._spectra.addItem(name)
        self.setEnabled(True)


if __name__ == "__main__":
    import sys

    app = QtGui.QApplication(sys.argv)

    def dump(*a):
        print(*a)

    widget = ChooseSpectraWidget()
    widget.set_spectra(("ms", "ms/ms"))
    widget.SELECTION_CHANGED.connect(dump)
    widget.show()
    sys.exit(app.exec_())
