/*
 * Decompiled with CFR 0.152.
 */
package shex;

import java.io.PrintStream;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Stream;
import org.apache.jena.atlas.lib.FileOps;
import org.apache.jena.atlas.lib.StreamOps;
import org.apache.jena.atlas.logging.LogCtl;
import org.apache.jena.cmd.ArgDecl;
import org.apache.jena.cmd.CmdException;
import org.apache.jena.cmd.CmdGeneral;
import org.apache.jena.riot.RiotException;
import org.apache.jena.shex.Shex;
import org.apache.jena.shex.ShexSchema;
import org.apache.jena.shex.parser.ShexParseException;
import org.apache.jena.sys.JenaSystem;

public class shex_parse
extends CmdGeneral {
    private static ArgDecl argOutput;
    private boolean printCompact = false;
    private boolean printJSON = false;
    private boolean printRDF = false;
    private boolean printText = false;
    private String shapesfile = null;

    public static void main(String ... argv) {
        new shex_parse(argv).mainRun();
    }

    public shex_parse(String[] argv) {
        super(argv);
        super.add(argOutput, "-output=", "Output formats: JSON, compact, RDF, text (default; terse)");
    }

    @Override
    protected String getSummary() {
        return "Usage: " + this.getCommandName() + " --out=FMT[,FMT] FILE";
    }

    @Override
    protected void processModulesAndArgs() {
        super.processModulesAndArgs();
        if (this.positionals.size() == 0) {
            System.err.println(this.getSummary());
            System.exit(0);
        }
        if (super.hasArg(argOutput)) {
            this.printCompact = false;
            this.printRDF = false;
            this.printText = false;
            this.printJSON = false;
            Function<String, Stream> f = x -> {
                String[] a = x.split(",");
                return Arrays.stream(a);
            };
            List<String> values = StreamOps.toList(this.getValues(argOutput).stream().flatMap(f).map(s -> s.toLowerCase()));
            this.printText = values.remove("text") || values.remove("t");
            this.printCompact = values.remove("compact") || values.remove("c");
            this.printRDF = values.remove("rdf") || values.remove("r");
            boolean bl = this.printRDF = values.remove("json") || values.remove("j");
            if (values.remove("all") || values.remove("a")) {
                this.printCompact = true;
                this.printRDF = true;
                this.printText = true;
                this.printJSON = true;
            }
            if (!values.isEmpty()) {
                throw new CmdException("Formats not recognized: " + values + " : Formats are 'text', 'compact', 'json', 'rdf' and 'all'");
            }
        } else {
            this.printCompact = false;
            this.printRDF = false;
            this.printJSON = true;
            this.printText = true;
        }
    }

    @Override
    protected String getCommandName() {
        return this.getClass().getSimpleName();
    }

    @Override
    protected void exec() {
        boolean multipleFiles = this.positionals.size() > 1;
        this.positionals.forEach(fn -> this.exec((String)fn, multipleFiles));
    }

    private void exec(String fn, boolean multipleFiles) {
        ShexSchema shapes;
        PrintStream out = System.out;
        PrintStream err = System.err;
        if (!FileOps.exists(fn)) {
            err.println(fn + " : File not found");
            return;
        }
        try {
            shapes = Shex.readSchema(fn);
        }
        catch (RiotException ex) {
            return;
        }
        catch (ShexParseException ex) {
            if (multipleFiles) {
                err.println(fn + " : ");
            }
            err.println(ex.getMessage());
            return;
        }
        boolean outputByPrev = false;
        if (this.printText) {
            outputByPrev = this.printText(out, err, shapes);
        }
        if (this.printCompact) {
            if (outputByPrev) {
                out.println("- - - - - - - - ");
                outputByPrev = false;
            }
            outputByPrev = this.printCompact(out, err, shapes);
        }
        if (this.printRDF) {
            if (outputByPrev) {
                out.println("- - - - - - - - ");
                outputByPrev = false;
            }
            outputByPrev = this.printRDF(out, err, shapes);
        }
    }

    private boolean printText(PrintStream out, PrintStream err, ShexSchema shapes) {
        Shex.printSchema(shapes);
        return true;
    }

    private boolean printRDF(PrintStream out, PrintStream err, ShexSchema shapes) {
        return true;
    }

    private boolean printCompact(PrintStream out, PrintStream err, ShexSchema shapes) {
        return false;
    }

    static {
        LogCtl.setLogging();
        JenaSystem.init();
        argOutput = new ArgDecl(true, "output", "out");
    }
}

