/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.modify;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.jena.atlas.data.BagFactory;
import org.apache.jena.atlas.data.DefaultDataBag;
import org.apache.jena.atlas.data.ThresholdPolicy;
import org.apache.jena.atlas.data.ThresholdPolicyFactory;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.atlas.lib.Pair;
import org.apache.jena.atlas.logging.Log;
import org.apache.jena.atlas.web.TypedInputStream;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.GraphUtil;
import org.apache.jena.graph.Node;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryExecutionFactory;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFDataMgr;
import org.apache.jena.riot.RDFLanguages;
import org.apache.jena.riot.RDFParser;
import org.apache.jena.sparql.ARQInternalErrorException;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.DatasetGraphFactory;
import org.apache.jena.sparql.core.DatasetGraphReadOnly;
import org.apache.jena.sparql.core.DynamicDatasets;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.sparql.engine.Plan;
import org.apache.jena.sparql.engine.QueryIterator;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.engine.binding.BindingRoot;
import org.apache.jena.sparql.graph.GraphFactory;
import org.apache.jena.sparql.graph.GraphOps;
import org.apache.jena.sparql.modify.TemplateLib;
import org.apache.jena.sparql.modify.request.Target;
import org.apache.jena.sparql.modify.request.UpdateAdd;
import org.apache.jena.sparql.modify.request.UpdateBinaryOp;
import org.apache.jena.sparql.modify.request.UpdateClear;
import org.apache.jena.sparql.modify.request.UpdateCopy;
import org.apache.jena.sparql.modify.request.UpdateCreate;
import org.apache.jena.sparql.modify.request.UpdateDataDelete;
import org.apache.jena.sparql.modify.request.UpdateDataInsert;
import org.apache.jena.sparql.modify.request.UpdateDeleteWhere;
import org.apache.jena.sparql.modify.request.UpdateDrop;
import org.apache.jena.sparql.modify.request.UpdateDropClear;
import org.apache.jena.sparql.modify.request.UpdateLoad;
import org.apache.jena.sparql.modify.request.UpdateModify;
import org.apache.jena.sparql.modify.request.UpdateMove;
import org.apache.jena.sparql.modify.request.UpdateVisitor;
import org.apache.jena.sparql.syntax.Element;
import org.apache.jena.sparql.syntax.ElementGroup;
import org.apache.jena.sparql.syntax.ElementNamedGraph;
import org.apache.jena.sparql.syntax.ElementTriplesBlock;
import org.apache.jena.sparql.system.SerializationFactoryFinder;
import org.apache.jena.sparql.util.Context;
import org.apache.jena.update.UpdateException;

public class UpdateEngineWorker
implements UpdateVisitor {
    protected final DatasetGraph datasetGraph;
    protected final boolean alwaysSilent = true;
    protected final Binding inputBinding;
    protected final Context context;

    public UpdateEngineWorker(DatasetGraph datasetGraph, Binding inputBinding, Context context2) {
        this.datasetGraph = datasetGraph;
        this.inputBinding = inputBinding;
        this.context = context2;
    }

    @Override
    public void visit(UpdateDrop update2) {
        this.execDropClear(update2, false);
    }

    @Override
    public void visit(UpdateClear update2) {
        this.execDropClear(update2, true);
    }

    protected void execDropClear(UpdateDropClear update2, boolean isClear) {
        if (update2.isAll()) {
            this.execDropClear(update2, null, true);
            this.execDropClearAllNamed(update2, isClear);
        } else if (update2.isAllNamed()) {
            this.execDropClearAllNamed(update2, isClear);
        } else if (update2.isDefault()) {
            this.execDropClear(update2, null, true);
        } else if (update2.isOneGraph()) {
            this.execDropClear(update2, update2.getGraph(), isClear);
        } else {
            throw new ARQInternalErrorException("Target is undefined: " + update2.getTarget());
        }
    }

    protected void execDropClear(UpdateDropClear update2, Node g, boolean isClear) {
        if (isClear) {
            if (g == null || this.datasetGraph.containsGraph(g)) {
                UpdateEngineWorker.graph(this.datasetGraph, g).clear();
            }
        } else {
            this.datasetGraph.removeGraph(g);
        }
    }

    protected void execDropClearAllNamed(UpdateDropClear update2, boolean isClear) {
        List<Node> list = Iter.toList(this.datasetGraph.listGraphNodes());
        for (Node gn : list) {
            this.execDropClear(update2, gn, isClear);
        }
    }

    @Override
    public void visit(UpdateCreate update2) {
        Node g = update2.getGraph();
        if (g == null) {
            return;
        }
        if (this.datasetGraph.containsGraph(g)) {
            return;
        }
        this.datasetGraph.addGraph(g, GraphFactory.createDefaultGraph());
    }

    @Override
    public void visit(UpdateLoad update2) {
        block10: {
            String source = update2.getSource();
            Node dest = update2.getDest();
            Graph graph = UpdateEngineWorker.graph(this.datasetGraph, dest);
            boolean loadBuffered = update2.getSilent() || !this.datasetGraph.supportsTransactionAbort();
            try {
                if (dest == null) {
                    if (loadBuffered) {
                        DatasetGraph dsg2 = DatasetGraphFactory.create();
                        RDFDataMgr.read(dsg2, source);
                        dsg2.find().forEachRemaining(this.datasetGraph::add);
                    } else {
                        RDFDataMgr.read(this.datasetGraph, source);
                    }
                    return;
                }
                TypedInputStream input = RDFDataMgr.open(source);
                String contentType = input.getContentType();
                Lang lang = RDFDataMgr.determineLang(source, contentType, Lang.TTL);
                if (lang == null) {
                    throw new UpdateException("Failed to determine the syntax for '" + source + "'");
                }
                if (!RDFLanguages.isTriples(lang)) {
                    throw new UpdateException("Attempt to load quads into a graph");
                }
                RDFParser parser = RDFParser.source(input.getInputStream()).forceLang(lang).build();
                if (loadBuffered) {
                    Graph g = GraphFactory.createGraphMem();
                    parser.parse(g);
                    GraphUtil.addInto(graph, g);
                } else {
                    parser.parse(graph);
                }
            }
            catch (RuntimeException ex) {
                if (update2.getSilent()) break block10;
                if (ex instanceof UpdateException) {
                    throw ex;
                }
                throw new UpdateException("Failed to LOAD '" + source + "' :: " + ex.getMessage(), ex);
            }
        }
    }

    @Override
    public void visit(UpdateAdd update2) {
        if (!this.validBinaryGraphOp(update2)) {
            return;
        }
        if (update2.getSrc().equals(update2.getDest())) {
            return;
        }
        UpdateEngineWorker.gsAddTriples(this.datasetGraph, update2.getSrc(), update2.getDest());
    }

    @Override
    public void visit(UpdateCopy update2) {
        if (!this.validBinaryGraphOp(update2)) {
            return;
        }
        if (update2.getSrc().equals(update2.getDest())) {
            return;
        }
        UpdateEngineWorker.gsCopy(this.datasetGraph, update2.getSrc(), update2.getDest(), update2.getSilent());
    }

    @Override
    public void visit(UpdateMove update2) {
        if (!this.validBinaryGraphOp(update2)) {
            return;
        }
        if (update2.getSrc().equals(update2.getDest())) {
            return;
        }
        UpdateEngineWorker.gsCopy(this.datasetGraph, update2.getSrc(), update2.getDest(), update2.getSilent());
        UpdateEngineWorker.gsDrop(this.datasetGraph, update2.getSrc(), true);
    }

    private boolean validBinaryGraphOp(UpdateBinaryOp update2) {
        if (update2.getSrc().isDefault()) {
            return true;
        }
        if (update2.getSrc().isOneNamedGraph()) {
            Node gn = update2.getSrc().getGraph();
            if (!this.datasetGraph.containsGraph(gn)) {
                if (!update2.getSilent()) {
                    UpdateEngineWorker.error("No such graph: " + gn);
                }
                return false;
            }
            return true;
        }
        UpdateEngineWorker.error("Invalid source target for oepration; " + update2.getSrc());
        return false;
    }

    protected static void gsCopy(DatasetGraph dsg, Target src, Target dest, boolean isSilent) {
        if (dest.equals(src)) {
            return;
        }
        UpdateEngineWorker.gsClear(dsg, dest, true);
        UpdateEngineWorker.gsAddTriples(dsg, src, dest);
    }

    protected static void gsAddTriples(DatasetGraph dsg, Target src, Target dest) {
        Graph gSrc = UpdateEngineWorker.graph(dsg, src);
        Graph gDest = UpdateEngineWorker.graph(dsg, dest);
        GraphOps.addAll(gDest, gSrc.find());
    }

    protected static void gsClear(DatasetGraph dsg, Target target, boolean isSilent) {
        Graph g = UpdateEngineWorker.graph(dsg, target);
        g.clear();
    }

    protected static void gsDrop(DatasetGraph dsg, Target target, boolean isSilent) {
        if (target.isDefault()) {
            dsg.getDefaultGraph().clear();
        } else {
            dsg.removeGraph(target.getGraph());
        }
    }

    @Override
    public void visit(UpdateDataInsert update2) {
        for (Quad quad : update2.getQuads()) {
            UpdateEngineWorker.addToDatasetGraph(this.datasetGraph, quad);
        }
    }

    @Override
    public void visit(UpdateDataDelete update2) {
        for (Quad quad : update2.getQuads()) {
            UpdateEngineWorker.deleteFromDatasetGraph(this.datasetGraph, quad);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void visit(UpdateDeleteWhere update2) {
        List<Quad> quads = update2.getQuads();
        Element el = this.elementFromQuads(quads);
        ThresholdPolicy policy = ThresholdPolicyFactory.policyFromContext(this.datasetGraph.getContext());
        try (DefaultDataBag<Binding> db = BagFactory.newDefaultBag(policy, SerializationFactoryFinder.bindingSerializationFactory());){
            Iterator<Binding> bindings2 = this.evalBindings(el);
            db.addAll(bindings2);
            Iter.close(bindings2);
            Iterator<Binding> it = db.iterator();
            UpdateEngineWorker.execDelete(this.datasetGraph, quads, null, it);
            Iter.close(it);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void visit(UpdateModify update2) {
        Node withGraph = update2.getWithIRI();
        Element elt = update2.getWherePattern();
        DatasetGraph dsg = this.processUsing(update2);
        if (dsg == null && withGraph != null) {
            elt = new ElementNamedGraph(withGraph, elt);
        }
        if (dsg == null) {
            dsg = this.datasetGraph;
        }
        Query query2 = this.elementToQuery(elt);
        ThresholdPolicy policy = ThresholdPolicyFactory.policyFromContext(this.datasetGraph.getContext());
        try (DefaultDataBag<Binding> db = BagFactory.newDefaultBag(policy, SerializationFactoryFinder.bindingSerializationFactory());){
            Iterator<Binding> bindings2 = UpdateEngineWorker.evalBindings(query2, dsg, this.inputBinding, this.context);
            db.addAll(bindings2);
            Iter.close(bindings2);
            Iterator<Binding> it = db.iterator();
            UpdateEngineWorker.execDelete(this.datasetGraph, update2.getDeleteQuads(), withGraph, it);
            Iter.close(it);
            Iterator<Binding> it2 = db.iterator();
            UpdateEngineWorker.execInsert(this.datasetGraph, update2.getInsertQuads(), withGraph, it2);
            Iter.close(it2);
        }
    }

    protected DatasetGraph processUsing(UpdateModify update2) {
        if (update2.getUsing().size() == 0 && update2.getUsingNamed().size() == 0) {
            return null;
        }
        return DynamicDatasets.dynamicDataset(update2.getUsing(), update2.getUsingNamed(), this.datasetGraph, false);
    }

    private Graph graphOrDummy(DatasetGraph dsg, Node gn) {
        Graph g = UpdateEngineWorker.graph(this.datasetGraph, gn);
        if (g == null) {
            g = GraphFactory.createGraphMem();
        }
        return g;
    }

    protected Element elementFromQuads(List<Quad> quads) {
        ElementGroup el = new ElementGroup();
        ElementTriplesBlock x = new ElementTriplesBlock();
        el.addElement(x);
        Node g = Quad.defaultGraphNodeGenerated;
        for (Quad q : quads) {
            if (q.getGraph() != g) {
                g = q.getGraph();
                x = new ElementTriplesBlock();
                if (g == null || g == Quad.defaultGraphNodeGenerated) {
                    el.addElement(x);
                } else {
                    ElementNamedGraph eng = new ElementNamedGraph(g, x);
                    el.addElement(eng);
                }
            }
            x.addTriple(q.asTriple());
        }
        return el;
    }

    private static Pair<List<Quad>, List<Quad>> split(Collection<Quad> quads) {
        ArrayList constQuads = new ArrayList(quads.size());
        ArrayList templateQuads = new ArrayList();
        quads.forEach(q -> {
            if (UpdateEngineWorker.constQuad(q)) {
                constQuads.add(q);
            } else {
                templateQuads.add(q);
            }
        });
        return Pair.create(constQuads, templateQuads);
    }

    private static boolean constQuad(Quad quad) {
        return UpdateEngineWorker.constTerm(quad.getGraph()) && UpdateEngineWorker.constTerm(quad.getSubject()) && UpdateEngineWorker.constTerm(quad.getPredicate()) && UpdateEngineWorker.constTerm(quad.getObject());
    }

    private static boolean constTerm(Node n) {
        return n.isURI() || n.isLiteral();
    }

    protected static void execDelete(DatasetGraph dsg, List<Quad> quads, Node dftGraph, Iterator<Binding> bindings2) {
        Pair<List<Quad>, List<Quad>> p = UpdateEngineWorker.split(quads);
        UpdateEngineWorker.execDelete(dsg, p.getLeft(), p.getRight(), dftGraph, bindings2);
    }

    protected static void execDelete(DatasetGraph dsg, List<Quad> onceQuads, List<Quad> templateQuads, Node dftGraph, Iterator<Binding> bindings2) {
        Iterator<Quad> it;
        if (onceQuads != null && bindings2.hasNext()) {
            onceQuads = TemplateLib.remapDefaultGraph(onceQuads, dftGraph);
            onceQuads.forEach(q -> UpdateEngineWorker.deleteFromDatasetGraph(dsg, q));
        }
        if ((it = TemplateLib.template(templateQuads, dftGraph, bindings2)) == null) {
            return;
        }
        it.forEachRemaining(q -> UpdateEngineWorker.deleteFromDatasetGraph(dsg, q));
    }

    protected static void execInsert(DatasetGraph dsg, List<Quad> quads, Node dftGraph, Iterator<Binding> bindings2) {
        Pair<List<Quad>, List<Quad>> p = UpdateEngineWorker.split(quads);
        UpdateEngineWorker.execInsert(dsg, p.getLeft(), p.getRight(), dftGraph, bindings2);
    }

    protected static void execInsert(DatasetGraph dsg, List<Quad> onceQuads, List<Quad> templateQuads, Node dftGraph, Iterator<Binding> bindings2) {
        Iterator<Quad> it;
        if (onceQuads != null && bindings2.hasNext()) {
            onceQuads = TemplateLib.remapDefaultGraph(onceQuads, dftGraph);
            onceQuads.forEach(q -> UpdateEngineWorker.addToDatasetGraph(dsg, q));
        }
        if ((it = TemplateLib.template(templateQuads, dftGraph, bindings2)) == null) {
            return;
        }
        it.forEachRemaining(q -> UpdateEngineWorker.addToDatasetGraph(dsg, q));
    }

    private static void addToDatasetGraph(DatasetGraph datasetGraph, Quad quad) {
        if (quad.isLegalAsData()) {
            datasetGraph.add(quad);
        }
    }

    private static void deleteFromDatasetGraph(DatasetGraph datasetGraph, Quad quad) {
        if (datasetGraph instanceof DatasetGraphReadOnly) {
            Log.warn(UpdateEngineWorker.class, "Read only dataset");
        }
        datasetGraph.delete(quad);
    }

    protected Query elementToQuery(Element pattern) {
        if (pattern == null) {
            return null;
        }
        Query query2 = new Query();
        query2.setQueryPattern(pattern);
        query2.setQuerySelectType();
        query2.setQueryResultStar(true);
        query2.resetResultVars();
        return query2;
    }

    protected Iterator<Binding> evalBindings(Element pattern) {
        Query query2 = this.elementToQuery(pattern);
        return UpdateEngineWorker.evalBindings(query2, this.datasetGraph, this.inputBinding, this.context);
    }

    protected static Iterator<Binding> evalBindings(Query query2, DatasetGraph dsg, Binding inputBinding, Context context2) {
        QueryIterator toReturn;
        if (query2 != null) {
            Plan plan = QueryExecutionFactory.createPlan(query2, dsg, inputBinding, context2);
            toReturn = plan.iterator();
        } else {
            toReturn = Iter.singleton(null != inputBinding ? inputBinding : BindingRoot.create());
        }
        return toReturn;
    }

    protected static Graph graph(DatasetGraph datasetGraph, Node gn) {
        if (gn == null || gn == Quad.defaultGraphNodeGenerated) {
            return datasetGraph.getDefaultGraph();
        }
        return datasetGraph.getGraph(gn);
    }

    protected static Graph graph(DatasetGraph datasetGraph, Target target) {
        if (target.isDefault()) {
            return datasetGraph.getDefaultGraph();
        }
        if (target.isOneNamedGraph()) {
            return UpdateEngineWorker.graph(datasetGraph, target.getGraph());
        }
        UpdateEngineWorker.error("Target does not name one graph: " + target);
        return null;
    }

    protected static void error(String msg) {
        throw new UpdateException(msg);
    }
}

