/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.servlets;

import org.apache.jena.fuseki.servlets.HttpAction;
import org.apache.jena.fuseki.servlets.ServletOps;

public interface ActionProcessor {
    default public void process(HttpAction action) {
        switch (action.getMethod()) {
            case "GET": {
                this.execGet(action);
                break;
            }
            case "POST": {
                this.execPost(action);
                break;
            }
            case "PATCH": {
                this.execPatch(action);
                break;
            }
            case "PUT": {
                this.execPut(action);
                break;
            }
            case "DELETE": {
                this.execDelete(action);
                break;
            }
            case "HEAD": {
                this.execHead(action);
                break;
            }
            case "OPTIONS": {
                this.execOptions(action);
                break;
            }
            case "TRACE": {
                this.execTrace(action);
            }
        }
    }

    default public void execHead(HttpAction action) {
        this.execAny("HEAD", action);
    }

    default public void execGet(HttpAction action) {
        this.execAny("GET", action);
    }

    default public void execPost(HttpAction action) {
        this.execAny("POST", action);
    }

    default public void execPatch(HttpAction action) {
        this.execAny("PATCH", action);
    }

    default public void execPut(HttpAction action) {
        this.execAny("PUT", action);
    }

    default public void execDelete(HttpAction action) {
        this.execAny("DELETE", action);
    }

    default public void execOptions(HttpAction action) {
        this.execAny("OPTIONS", action);
    }

    default public void execTrace(HttpAction action) {
        this.execAny("TRACE", action);
    }

    default public void execAny(String methodName, HttpAction action) {
        ServletOps.errorMethodNotAllowed(methodName);
    }
}

