/*
 * Decompiled with CFR 0.152.
 */
package examples;

import edu.rpi.tw.jena.query.fulltext.EntityDefinition;
import edu.rpi.tw.jena.query.fulltext.TextDatasetFactory;
import edu.rpi.tw.jena.query.fulltext.TextIndexConfig;
import org.apache.jena.atlas.lib.StrUtils;
import org.apache.jena.atlas.logging.LogCtl;
import org.apache.jena.query.Dataset;
import org.apache.jena.query.DatasetFactory;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.QueryExecutionFactory;
import org.apache.jena.query.QueryFactory;
import org.apache.jena.query.ReadWrite;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.riot.RDFDataMgr;
import org.apache.jena.sparql.core.Prologue;
import org.apache.jena.sparql.util.QueryExecUtils;
import org.apache.lucene.store.ByteBuffersDirectory;
import org.apache.lucene.store.Directory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JenaTextExample1 {
    static Logger log;

    public static void main(String ... argv) {
        Dataset ds = JenaTextExample1.createCode();
        JenaTextExample1.loadData(ds, "data.ttl");
        JenaTextExample1.queryData(ds);
    }

    public static Dataset createCode() {
        log.info("Construct an in-memory dataset with in-memory lucene index using code");
        Dataset ds1 = DatasetFactory.create();
        EntityDefinition entDef = new EntityDefinition("uri", "text");
        ByteBuffersDirectory dir = new ByteBuffersDirectory();
        Dataset ds = TextDatasetFactory.createLucene(ds1, (Directory)dir, new TextIndexConfig(entDef));
        return ds;
    }

    public static Dataset createAssembler() {
        log.info("Construct text dataset using an assembler description");
        Dataset ds = DatasetFactory.assemble((String)"text-config.ttl", (String)"http://localhost/jena_example/#text_dataset");
        return ds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadData(Dataset dataset, String file) {
        log.info("Start loading");
        long startTime = System.nanoTime();
        dataset.begin(ReadWrite.WRITE);
        try {
            Model m = dataset.getDefaultModel();
            RDFDataMgr.read((Model)m, (String)file);
            dataset.commit();
        }
        finally {
            dataset.end();
        }
        long finishTime = System.nanoTime();
        double time = (double)(finishTime - startTime) / 1000000.0;
        log.info(String.format("Finish loading - %.2fms", time));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void queryData(Dataset dataset) {
        log.info("START");
        long startTime = System.nanoTime();
        String pre = StrUtils.strjoinNL((String[])new String[]{"PREFIX : <http://example/>", "PREFIX text: <http://jena.apache.org/fulltext#>", "PREFIX rdfs: <http://www.w3.org/2000/01/rdf-schema#>"});
        String qs = StrUtils.strjoinNL((String[])new String[]{"SELECT * ", " { ?s text:search (rdfs:label 'X1') ;", "      rdfs:label ?label", " }"});
        dataset.begin(ReadWrite.READ);
        try {
            Query q = QueryFactory.create((String)(pre + "\n" + qs));
            QueryExecution qexec = QueryExecutionFactory.create((Query)q, (Dataset)dataset);
            QueryExecUtils.executeQuery((Prologue)q, (QueryExecution)qexec);
        }
        finally {
            dataset.end();
        }
        long finishTime = System.nanoTime();
        double time = (double)(finishTime - startTime) / 1000000.0;
        log.info(String.format("FINISH - %.2fms", time));
    }

    static {
        LogCtl.setLog4j2();
        log = LoggerFactory.getLogger((String)"JenaTextExample");
    }
}

