/*
 * Decompiled with CFR 0.152.
 */
package edu.rpi.tw.jena.query.fulltext.assembler;

import edu.rpi.tw.jena.query.fulltext.TextIndexException;
import edu.rpi.tw.jena.query.fulltext.analyzer.Util;
import edu.rpi.tw.jena.query.fulltext.assembler.TextVocab;
import org.apache.jena.assembler.Assembler;
import org.apache.jena.assembler.Mode;
import org.apache.jena.assembler.assemblers.AssemblerBase;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;

public class LocalizedAnalyzerAssembler
extends AssemblerBase {
    public Analyzer open(Assembler a, Resource root, Mode mode) {
        if (root.hasProperty(TextVocab.pLanguage)) {
            RDFNode node = root.getProperty(TextVocab.pLanguage).getObject();
            if (!node.isLiteral()) {
                throw new TextIndexException("text:language property must be a string : " + node);
            }
            String lang = node.toString();
            return Util.getLocalizedAnalyzer(lang);
        }
        return new StandardAnalyzer();
    }
}

