"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ProvisionConfig = exports.ProvisionConfigProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const fc3_generated_1 = require("./fc3.generated");
Object.defineProperty(exports, "ProvisionConfigProperty", { enumerable: true, get: function () { return fc3_generated_1.RosProvisionConfig; } });
/**
 * This class encapsulates and extends the ROS resource type `ALIYUN::FC3::ProvisionConfig`, which is used to create a provisioned configuration in Function Compute 3.0.
 * @Note This class may have some new functions to facilitate development, so it is recommended to use this class instead of `RosProvisionConfig`for a more convenient development experience.
 * See https://www.alibabacloud.com/help/ros/developer-reference/aliyun-fc3-provisionconfig
 */
class ProvisionConfig extends ros.Resource {
    /**
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        this.scope = scope;
        this.id = id;
        this.props = props;
        this.enableResourcePropertyConstraint = enableResourcePropertyConstraint;
        const rosProvisionConfig = new fc3_generated_1.RosProvisionConfig(this, id, {
            defaultTarget: props.defaultTarget,
            alwaysAllocateCpu: props.alwaysAllocateCpu,
            functionName: props.functionName,
            targetTrackingPolicies: props.targetTrackingPolicies,
            scheduledActions: props.scheduledActions,
            qualifier: props.qualifier,
            alwaysAllocateGpu: props.alwaysAllocateGpu,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosProvisionConfig;
    }
}
exports.ProvisionConfig = ProvisionConfig;
//# sourceMappingURL=data:application/json;base64,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