"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.FunctionInvoker = exports.FunctionInvokerProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const fc3_generated_1 = require("./fc3.generated");
Object.defineProperty(exports, "FunctionInvokerProperty", { enumerable: true, get: function () { return fc3_generated_1.RosFunctionInvoker; } });
/**
 * This class encapsulates and extends the ROS resource type `ALIYUN::FC3::FunctionInvoker`.
 * @Note This class may have some new functions to facilitate development, so it is recommended to use this class instead of `RosFunctionInvoker`for a more convenient development experience.
 * See https://www.alibabacloud.com/help/ros/developer-reference/aliyun-fc3-functioninvoker
 */
class FunctionInvoker extends ros.Resource {
    /**
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        this.scope = scope;
        this.id = id;
        this.props = props;
        this.enableResourcePropertyConstraint = enableResourcePropertyConstraint;
        const rosFunctionInvoker = new fc3_generated_1.RosFunctionInvoker(this, id, {
            functionName: props.functionName,
            executeVersion: props.executeVersion,
            serviceRegionId: props.serviceRegionId,
            async: props.async === undefined || props.async === null ? false : props.async,
            event: props.event,
            qualifier: props.qualifier,
            checkError: props.checkError,
            checkAsyncInvocation: props.checkAsyncInvocation,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosFunctionInvoker;
        this.attrResult = rosFunctionInvoker.attrResult;
        this.attrResultType = rosFunctionInvoker.attrResultType;
    }
}
exports.FunctionInvoker = FunctionInvoker;
//# sourceMappingURL=data:application/json;base64,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