## interzoid_full_name_match_key

Python package for generating a similarity key from the input data used to match with other similar full name data. Use the generated similarity key, rather than the actual data itself, to match and/or sort individual name data by similarity. This avoids the problems of data inconsistency, misspellings, and name variations when matching within a single dataset, and can also help matching across datasets or for more advanced searching.

The key generation is based on a series of tests, algorithms, AI, and an ever-growing body of Machine Learning-based generated knowledge. As the context of the data is known, in this case individual person names, it performs far better than generic string comparison algorithms.

### Usage

To generate the similarity key, you will need the following information:

- an API License key, available at https://www.interzoid.com
- an individual full name to generate the similarity key for

An API is called by the package to access the Cloud server that generates the similarity key.

Begin by importing the package:

    from interzoid_full_name_match_key import full_name_match_key

Then, provide the information into the get_key() method:

    sim_key, credits, http_code, msg = full_name_match_key.get_key('YOUR-API-KEY','Mr. Jim Smith')

    #200 is the HTTP status for OK
    if http_code == 200:  
        print(sim_key, msg, credits)
    else:
        print(sim_key, "error:", http_code, msg, credits)

The return values will be the generated similarity key, a code (success or failure), how many remaining credits on your API key, and any error messages. The similarity key can be used to search for other similar individual person names, to sort large datasets by similarity, and perhaps use additional attributes to identify duplicates/redundancy.

Examples:

    jim smith  ->  7Kbdndkyln_1iZckUFnSOpwEve7t_USswPjJDAy2Qek
    James E. Smyth  ->  7Kbdndkyln_1iZckUFnSOpwEve7t_USswPjJDAy2Qek

    SALLY ANDERSON  ->   fOjMwYe9hOgKTa5LCDruK-NgkyDzasOV9Fqf-luTWXw
    Ms Sallie P. Andersen  ->  fOjMwYe9hOgKTa5LCDruK-NgkyDzasOV9Fqf-luTWXw