# coding: utf-8

"""
    PocketSmith

    The public PocketSmith API  # noqa: E501

    The version of the OpenAPI document: 2.0
    Contact: api@pocketsmith.com
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from pocketsmith.api_client import ApiClient
from pocketsmith.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)


class BudgetingApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def get_budget_summary(self, id, period, interval, start_date, end_date, **kwargs):  # noqa: E501
        """Get budget summary for user  # noqa: E501

        Get the user's budget summary, containing an expense and income analysis for all categories (excluding transfer categories) for the given period and date range. Akin to the overall budget shown on the Budget page in PocketSmith.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_budget_summary(id, period, interval, start_date, end_date, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: The unique identifier of the user. (required)
        :param str period: The period to analyse in, one of `weeks`, `months` or `years`. Also supported is `event`, although event period analysis is only possible when the budget events gathered align, so in this case where all categories are analysed together, it's highly unlikely that event period analysis will be possible. (required)
        :param int interval: The period interval, e.g. if the interval is 2 and the period is weeks, the budget will be analysed fortnightly. (required)
        :param str start_date: The date to start analysing the budget from. This will be bumped out to make full periods as necessary. (required)
        :param str end_date: The date to stop analysing the budget from. This will be bumped out to make full periods as necessary. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[BudgetAnalysisPackage]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_budget_summary_with_http_info(id, period, interval, start_date, end_date, **kwargs)  # noqa: E501

    def get_budget_summary_with_http_info(self, id, period, interval, start_date, end_date, **kwargs):  # noqa: E501
        """Get budget summary for user  # noqa: E501

        Get the user's budget summary, containing an expense and income analysis for all categories (excluding transfer categories) for the given period and date range. Akin to the overall budget shown on the Budget page in PocketSmith.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_budget_summary_with_http_info(id, period, interval, start_date, end_date, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: The unique identifier of the user. (required)
        :param str period: The period to analyse in, one of `weeks`, `months` or `years`. Also supported is `event`, although event period analysis is only possible when the budget events gathered align, so in this case where all categories are analysed together, it's highly unlikely that event period analysis will be possible. (required)
        :param int interval: The period interval, e.g. if the interval is 2 and the period is weeks, the budget will be analysed fortnightly. (required)
        :param str start_date: The date to start analysing the budget from. This will be bumped out to make full periods as necessary. (required)
        :param str end_date: The date to stop analysing the budget from. This will be bumped out to make full periods as necessary. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[BudgetAnalysisPackage], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id',
            'period',
            'interval',
            'start_date',
            'end_date'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_budget_summary" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `get_budget_summary`")  # noqa: E501
        # verify the required parameter 'period' is set
        if self.api_client.client_side_validation and ('period' not in local_var_params or  # noqa: E501
                                                        local_var_params['period'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `period` when calling `get_budget_summary`")  # noqa: E501
        # verify the required parameter 'interval' is set
        if self.api_client.client_side_validation and ('interval' not in local_var_params or  # noqa: E501
                                                        local_var_params['interval'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `interval` when calling `get_budget_summary`")  # noqa: E501
        # verify the required parameter 'start_date' is set
        if self.api_client.client_side_validation and ('start_date' not in local_var_params or  # noqa: E501
                                                        local_var_params['start_date'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `start_date` when calling `get_budget_summary`")  # noqa: E501
        # verify the required parameter 'end_date' is set
        if self.api_client.client_side_validation and ('end_date' not in local_var_params or  # noqa: E501
                                                        local_var_params['end_date'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `end_date` when calling `get_budget_summary`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []
        if 'period' in local_var_params and local_var_params['period'] is not None:  # noqa: E501
            query_params.append(('period', local_var_params['period']))  # noqa: E501
        if 'interval' in local_var_params and local_var_params['interval'] is not None:  # noqa: E501
            query_params.append(('interval', local_var_params['interval']))  # noqa: E501
        if 'start_date' in local_var_params and local_var_params['start_date'] is not None:  # noqa: E501
            query_params.append(('start_date', local_var_params['start_date']))  # noqa: E501
        if 'end_date' in local_var_params and local_var_params['end_date'] is not None:  # noqa: E501
            query_params.append(('end_date', local_var_params['end_date']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['developerKey']  # noqa: E501

        return self.api_client.call_api(
            '/users/{id}/budget_summary', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[BudgetAnalysisPackage]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_trend_analysis(self, id, period, interval, start_date, end_date, categories, scenarios, **kwargs):  # noqa: E501
        """Get trend analysis for user  # noqa: E501

        Get an income and/or expense budget analysis for the given date range and period across any number of categories and scenarios. Akin to the Trends page in PocketSmith.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_trend_analysis(id, period, interval, start_date, end_date, categories, scenarios, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: The unique identifier of the user. (required)
        :param str period: The period to analyse in, one of `weeks`, `months` or `years`. Also supported is `event`, although event period analysis is only possible when the budget events gathered align, so in this case where all categories are analysed together, it's highly unlikely that event period analysis will be possible. (required)
        :param int interval: The period interval, e.g. if the interval is 2 and the period is weeks, the budget will be analysed fortnightly. (required)
        :param str start_date: The date to start analysing the budget from. This will be bumped out to make full periods as necessary. (required)
        :param str end_date: The date to stop analysing the budget from. This will be bumped out to make full periods as necessary. (required)
        :param str categories: A comma-separated list of category IDs to analyse. (required)
        :param str scenarios: A comma-separated list of scenario IDs to analyse. You're likely going to want to include all a user's scenarios here, unless you have reason to only analyse for a subset of scenarios. Regardless of what scenarios are analysed, all actuals (transactions) across all accounts will be included. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[BudgetAnalysisPackage]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_trend_analysis_with_http_info(id, period, interval, start_date, end_date, categories, scenarios, **kwargs)  # noqa: E501

    def get_trend_analysis_with_http_info(self, id, period, interval, start_date, end_date, categories, scenarios, **kwargs):  # noqa: E501
        """Get trend analysis for user  # noqa: E501

        Get an income and/or expense budget analysis for the given date range and period across any number of categories and scenarios. Akin to the Trends page in PocketSmith.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_trend_analysis_with_http_info(id, period, interval, start_date, end_date, categories, scenarios, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: The unique identifier of the user. (required)
        :param str period: The period to analyse in, one of `weeks`, `months` or `years`. Also supported is `event`, although event period analysis is only possible when the budget events gathered align, so in this case where all categories are analysed together, it's highly unlikely that event period analysis will be possible. (required)
        :param int interval: The period interval, e.g. if the interval is 2 and the period is weeks, the budget will be analysed fortnightly. (required)
        :param str start_date: The date to start analysing the budget from. This will be bumped out to make full periods as necessary. (required)
        :param str end_date: The date to stop analysing the budget from. This will be bumped out to make full periods as necessary. (required)
        :param str categories: A comma-separated list of category IDs to analyse. (required)
        :param str scenarios: A comma-separated list of scenario IDs to analyse. You're likely going to want to include all a user's scenarios here, unless you have reason to only analyse for a subset of scenarios. Regardless of what scenarios are analysed, all actuals (transactions) across all accounts will be included. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[BudgetAnalysisPackage], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id',
            'period',
            'interval',
            'start_date',
            'end_date',
            'categories',
            'scenarios'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_trend_analysis" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `get_trend_analysis`")  # noqa: E501
        # verify the required parameter 'period' is set
        if self.api_client.client_side_validation and ('period' not in local_var_params or  # noqa: E501
                                                        local_var_params['period'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `period` when calling `get_trend_analysis`")  # noqa: E501
        # verify the required parameter 'interval' is set
        if self.api_client.client_side_validation and ('interval' not in local_var_params or  # noqa: E501
                                                        local_var_params['interval'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `interval` when calling `get_trend_analysis`")  # noqa: E501
        # verify the required parameter 'start_date' is set
        if self.api_client.client_side_validation and ('start_date' not in local_var_params or  # noqa: E501
                                                        local_var_params['start_date'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `start_date` when calling `get_trend_analysis`")  # noqa: E501
        # verify the required parameter 'end_date' is set
        if self.api_client.client_side_validation and ('end_date' not in local_var_params or  # noqa: E501
                                                        local_var_params['end_date'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `end_date` when calling `get_trend_analysis`")  # noqa: E501
        # verify the required parameter 'categories' is set
        if self.api_client.client_side_validation and ('categories' not in local_var_params or  # noqa: E501
                                                        local_var_params['categories'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `categories` when calling `get_trend_analysis`")  # noqa: E501
        # verify the required parameter 'scenarios' is set
        if self.api_client.client_side_validation and ('scenarios' not in local_var_params or  # noqa: E501
                                                        local_var_params['scenarios'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `scenarios` when calling `get_trend_analysis`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []
        if 'period' in local_var_params and local_var_params['period'] is not None:  # noqa: E501
            query_params.append(('period', local_var_params['period']))  # noqa: E501
        if 'interval' in local_var_params and local_var_params['interval'] is not None:  # noqa: E501
            query_params.append(('interval', local_var_params['interval']))  # noqa: E501
        if 'start_date' in local_var_params and local_var_params['start_date'] is not None:  # noqa: E501
            query_params.append(('start_date', local_var_params['start_date']))  # noqa: E501
        if 'end_date' in local_var_params and local_var_params['end_date'] is not None:  # noqa: E501
            query_params.append(('end_date', local_var_params['end_date']))  # noqa: E501
        if 'categories' in local_var_params and local_var_params['categories'] is not None:  # noqa: E501
            query_params.append(('categories', local_var_params['categories']))  # noqa: E501
        if 'scenarios' in local_var_params and local_var_params['scenarios'] is not None:  # noqa: E501
            query_params.append(('scenarios', local_var_params['scenarios']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['developerKey']  # noqa: E501

        return self.api_client.call_api(
            '/users/{id}/trend_analysis', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[BudgetAnalysisPackage]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_budgets(self, id, **kwargs):  # noqa: E501
        """List budget for user  # noqa: E501

        Lists the user's budget, consisting of one or more budget analysis packages, one per category. Akin to the list on the Budget page in PocketSmith.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_budgets(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: The unique identifier of the account. (required)
        :param bool roll_up: Whether parent categories should have their children rolled up into them. When used, the children will still appear in the collection on their own, but their actual and forecast figures will be rolled up to the root parent.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[BudgetAnalysisPackage]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.list_budgets_with_http_info(id, **kwargs)  # noqa: E501

    def list_budgets_with_http_info(self, id, **kwargs):  # noqa: E501
        """List budget for user  # noqa: E501

        Lists the user's budget, consisting of one or more budget analysis packages, one per category. Akin to the list on the Budget page in PocketSmith.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_budgets_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: The unique identifier of the account. (required)
        :param bool roll_up: Whether parent categories should have their children rolled up into them. When used, the children will still appear in the collection on their own, but their actual and forecast figures will be rolled up to the root parent.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[BudgetAnalysisPackage], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id',
            'roll_up'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_budgets" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `list_budgets`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []
        if 'roll_up' in local_var_params and local_var_params['roll_up'] is not None:  # noqa: E501
            query_params.append(('roll_up', local_var_params['roll_up']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['developerKey']  # noqa: E501

        return self.api_client.call_api(
            '/users/{id}/budget', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[BudgetAnalysisPackage]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)
