/*
 * Decompiled with CFR 0.152.
 */
package eu.quanticol.moonlight.script;

import eu.quanticol.moonlight.TemporalMonitorProducer;
import eu.quanticol.moonlight.core.base.MoonLightRecord;
import eu.quanticol.moonlight.core.formula.Interval;
import eu.quanticol.moonlight.offline.signal.RecordHandler;
import eu.quanticol.moonlight.script.BiParametricExpressionEvaluator;
import eu.quanticol.moonlight.script.MoonLightScriptBaseVisitor;
import eu.quanticol.moonlight.script.MoonLightScriptParser;
import eu.quanticol.moonlight.script.NameResolver;
import eu.quanticol.moonlight.script.ParametricExpressionEvaluator;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;

public class TemporalMonitoringGenerator
extends MoonLightScriptBaseVisitor<TemporalMonitorProducer> {
    private final RecordHandler inputHandler;
    private final RecordHandler signalHandler;
    private final NameResolver resolver;
    private final Map<String, TemporalMonitorProducer> producers;
    private final Map<String, RecordHandler> formulaParameters;

    public TemporalMonitoringGenerator(Map<String, TemporalMonitorProducer> producers, NameResolver resolver, Map<String, RecordHandler> formulaParameters, RecordHandler inputHandler, RecordHandler signalHandler) {
        this.inputHandler = inputHandler;
        this.signalHandler = signalHandler;
        this.resolver = resolver;
        this.producers = producers;
        this.formulaParameters = formulaParameters;
    }

    @Override
    public TemporalMonitorProducer visitImplyExpression(MoonLightScriptParser.ImplyExpressionContext ctx) {
        TemporalMonitorProducer left = (TemporalMonitorProducer)ctx.left.accept(this);
        TemporalMonitorProducer right = (TemporalMonitorProducer)ctx.right.accept(this);
        return TemporalMonitorProducer.produceImplication((TemporalMonitorProducer)left, (TemporalMonitorProducer)right);
    }

    @Override
    public TemporalMonitorProducer visitNotExpression(MoonLightScriptParser.NotExpressionContext ctx) {
        TemporalMonitorProducer arg = (TemporalMonitorProducer)ctx.arg.accept(this);
        return TemporalMonitorProducer.produceNegation((TemporalMonitorProducer)arg);
    }

    @Override
    public TemporalMonitorProducer visitFalseExpression(MoonLightScriptParser.FalseExpressionContext ctx) {
        return TemporalMonitorProducer.produceFalse();
    }

    @Override
    public TemporalMonitorProducer visitOnceExpression(MoonLightScriptParser.OnceExpressionContext ctx) {
        TemporalMonitorProducer arg = (TemporalMonitorProducer)ctx.argument.accept(this);
        if (ctx.interval() == null) {
            return TemporalMonitorProducer.produceOnce((TemporalMonitorProducer)arg);
        }
        return TemporalMonitorProducer.produceOnce((TemporalMonitorProducer)arg, this.generateIntervalFunction(ctx.interval()));
    }

    private Function<MoonLightRecord, Interval> generateIntervalFunction(MoonLightScriptParser.IntervalContext interval) {
        ParametricExpressionEvaluator evaluator = new ParametricExpressionEvaluator(this.resolver, this.inputHandler);
        Function from = (Function)interval.from.accept(evaluator);
        Function to = (Function)interval.to.accept(evaluator);
        return r -> new Interval((Number)from.apply(r), (Number)to.apply(r));
    }

    @Override
    public TemporalMonitorProducer visitBracketExpression(MoonLightScriptParser.BracketExpressionContext ctx) {
        return (TemporalMonitorProducer)ctx.expression().accept(this);
    }

    @Override
    public TemporalMonitorProducer visitUntilExpression(MoonLightScriptParser.UntilExpressionContext ctx) {
        TemporalMonitorProducer left = (TemporalMonitorProducer)ctx.left.accept(this);
        TemporalMonitorProducer right = (TemporalMonitorProducer)ctx.right.accept(this);
        if (ctx.interval() == null) {
            return TemporalMonitorProducer.produceUntil((TemporalMonitorProducer)left, (TemporalMonitorProducer)right);
        }
        Function<MoonLightRecord, Interval> interval = this.generateIntervalFunction(ctx.interval());
        return TemporalMonitorProducer.produceUntil((TemporalMonitorProducer)left, interval, (TemporalMonitorProducer)right);
    }

    @Override
    public TemporalMonitorProducer visitSinceExpression(MoonLightScriptParser.SinceExpressionContext ctx) {
        TemporalMonitorProducer left = (TemporalMonitorProducer)ctx.left.accept(this);
        TemporalMonitorProducer right = (TemporalMonitorProducer)ctx.right.accept(this);
        if (ctx.interval() == null) {
            return TemporalMonitorProducer.produceSince((TemporalMonitorProducer)left, (TemporalMonitorProducer)right);
        }
        Function<MoonLightRecord, Interval> interval = this.generateIntervalFunction(ctx.interval());
        return TemporalMonitorProducer.produceSince((TemporalMonitorProducer)left, interval, (TemporalMonitorProducer)right);
    }

    @Override
    public TemporalMonitorProducer visitAndExpression(MoonLightScriptParser.AndExpressionContext ctx) {
        TemporalMonitorProducer left = (TemporalMonitorProducer)ctx.left.accept(this);
        TemporalMonitorProducer right = (TemporalMonitorProducer)ctx.right.accept(this);
        return TemporalMonitorProducer.produceAnd((TemporalMonitorProducer)left, (TemporalMonitorProducer)right);
    }

    @Override
    public TemporalMonitorProducer visitTrueExpression(MoonLightScriptParser.TrueExpressionContext ctx) {
        return TemporalMonitorProducer.produceTrue();
    }

    @Override
    public TemporalMonitorProducer visitReferenceExpression(MoonLightScriptParser.ReferenceExpressionContext ctx) {
        String name = ctx.name.getText();
        if (this.inputHandler.isAVariable(name)) {
            int idx = this.inputHandler.getVariableIndex(name);
            return TemporalMonitorProducer.produceAtomic((r, s) -> r.getDoubleOf(idx));
        }
        if (this.signalHandler.isAVariable(name)) {
            int idx = this.signalHandler.getVariableIndex(name);
            return TemporalMonitorProducer.produceAtomic((r, s) -> s.getDoubleOf(idx));
        }
        if (this.producers.containsKey(name)) {
            RecordHandler callee = this.formulaParameters.get(name);
            ParametricExpressionEvaluator evaluator = new ParametricExpressionEvaluator(this.resolver, this.inputHandler);
            List args = ctx.args.stream().map(e -> (Function)e.accept(evaluator)).collect(Collectors.toList());
            return TemporalMonitorProducer.produceCall((TemporalMonitorProducer)this.producers.get(name), (RecordHandler)callee, args);
        }
        return this.defaultResult();
    }

    protected TemporalMonitorProducer defaultResult() {
        return TemporalMonitorProducer.produceFalse();
    }

    @Override
    public TemporalMonitorProducer visitGloballyExpression(MoonLightScriptParser.GloballyExpressionContext ctx) {
        TemporalMonitorProducer arg = (TemporalMonitorProducer)ctx.argument.accept(this);
        if (ctx.interval() == null) {
            return TemporalMonitorProducer.produceGlobally((TemporalMonitorProducer)arg);
        }
        Function<MoonLightRecord, Interval> interval = this.generateIntervalFunction(ctx.interval());
        return TemporalMonitorProducer.produceGlobally((TemporalMonitorProducer)arg, interval);
    }

    @Override
    public TemporalMonitorProducer visitOrExpression(MoonLightScriptParser.OrExpressionContext ctx) {
        TemporalMonitorProducer left = (TemporalMonitorProducer)ctx.left.accept(this);
        TemporalMonitorProducer right = (TemporalMonitorProducer)ctx.right.accept(this);
        return TemporalMonitorProducer.produceOr((TemporalMonitorProducer)left, (TemporalMonitorProducer)right);
    }

    @Override
    public TemporalMonitorProducer visitHistoricallyExpression(MoonLightScriptParser.HistoricallyExpressionContext ctx) {
        TemporalMonitorProducer arg = (TemporalMonitorProducer)ctx.argument.accept(this);
        if (ctx.interval() == null) {
            return TemporalMonitorProducer.produceHistorically((TemporalMonitorProducer)arg);
        }
        Function<MoonLightRecord, Interval> interval = this.generateIntervalFunction(ctx.interval());
        return TemporalMonitorProducer.produceHistorically((TemporalMonitorProducer)arg, interval);
    }

    @Override
    public TemporalMonitorProducer visitEventuallyExpression(MoonLightScriptParser.EventuallyExpressionContext ctx) {
        TemporalMonitorProducer arg = (TemporalMonitorProducer)ctx.argument.accept(this);
        if (ctx.interval() == null) {
            return TemporalMonitorProducer.produceEventually((TemporalMonitorProducer)arg);
        }
        Function<MoonLightRecord, Interval> interval = this.generateIntervalFunction(ctx.interval());
        return TemporalMonitorProducer.produceEventually((TemporalMonitorProducer)arg, interval);
    }

    @Override
    public TemporalMonitorProducer visitRelationExpression(MoonLightScriptParser.RelationExpressionContext ctx) {
        BiParametricExpressionEvaluator expressionEvaluator = new BiParametricExpressionEvaluator(this.resolver, this.inputHandler, this.signalHandler);
        BiFunction<MoonLightRecord, MoonLightRecord, Double> left = expressionEvaluator.eval(ctx.left);
        BiFunction<MoonLightRecord, MoonLightRecord, Double> right = expressionEvaluator.eval(ctx.right);
        return TemporalMonitorProducer.produceAtomic(left, (String)ctx.op.getText(), right);
    }

    public TemporalMonitorProducer eval(MoonLightScriptParser.ExpressionContext formula) {
        return (TemporalMonitorProducer)formula.accept(this);
    }
}

