/*
 * Decompiled with CFR 0.152.
 */
package eu.quanticol.moonlight.script;

import eu.quanticol.moonlight.script.MoonLightParseError;
import eu.quanticol.moonlight.script.MoonLightScriptParser;
import eu.quanticol.moonlight.script.MoonLightType;
import eu.quanticol.moonlight.script.TypeChecker;
import eu.quanticol.moonlight.script.TypeEnvironment;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.ParserRuleContext;

public class ScriptValidator {
    private final List<MoonLightParseError> errors;
    private final TypeEnvironment typeEnvironment;
    private final Map<String, ParserRuleContext> symbols;
    private boolean isSpatial = true;

    public ScriptValidator() {
        this(Collections.synchronizedList(new LinkedList()));
    }

    public ScriptValidator(List<MoonLightParseError> errors) {
        this.errors = errors;
        this.typeEnvironment = new TypeEnvironment();
        this.symbols = new HashMap<String, ParserRuleContext>();
    }

    public boolean withErrors() {
        return !this.errors.isEmpty();
    }

    public List<MoonLightParseError> getErrors() {
        return this.errors;
    }

    public boolean validate(MoonLightScriptParser.ModelContext ctx) {
        ctx.types.forEach(this::recordCustomType);
        ctx.constants.forEach(this::recordConstant);
        this.recordScriptSignal(ctx.scriptSignal());
        this.recordScriptSpace(ctx.scriptSpace());
        ctx.formulas.forEach(this::recordFormula);
        return !this.withErrors();
    }

    private void recordFormula(MoonLightScriptParser.ScriptFormulaContext scriptFormulaContext) {
        if (this.checkForDuplicatedName(scriptFormulaContext.name.getText(), scriptFormulaContext) && scriptFormulaContext.parameters.stream().allMatch(lv -> this.checkForDuplicatedName(lv.name.getText(), (ParserRuleContext)lv))) {
            TypeEnvironment te = this.typeEnvironment.addLocal(this.getLocalContext(scriptFormulaContext.parameters));
            TypeChecker tc = new TypeChecker(this.errors, te, TypeChecker.EvaluationContext.STATE, this.isSpatial);
            tc.checkBoolean(scriptFormulaContext.formula);
            this.typeEnvironment.addFormula(scriptFormulaContext.name.getText(), (MoonLightType[])scriptFormulaContext.parameters.stream().map(p -> MoonLightType.typeOf(p.type.getText())).toArray(MoonLightType[]::new));
        }
    }

    private Map<String, MoonLightType> getLocalContext(List<MoonLightScriptParser.VariableDeclarationContext> parameters) {
        return parameters.stream().collect(Collectors.toMap(lv -> lv.name.getText(), lv -> MoonLightType.typeOf(lv.type.getText())));
    }

    private void recordScriptSpace(MoonLightScriptParser.ScriptSpaceContext scriptSpace) {
        if (scriptSpace == null) {
            this.isSpatial = false;
        } else {
            scriptSpace.edgeVariables.forEach(this::recordEdgeVariable);
        }
    }

    private void recordEdgeVariable(MoonLightScriptParser.VariableDeclarationContext variableDeclarationContext) {
        if (this.checkForDuplicatedName(variableDeclarationContext.name.getText(), variableDeclarationContext)) {
            this.typeEnvironment.addEdge(variableDeclarationContext.name.getText(), MoonLightType.typeOf(variableDeclarationContext.type.getText()));
            this.symbols.put(variableDeclarationContext.name.getText(), variableDeclarationContext);
        }
    }

    private void recordLocationVariable(MoonLightScriptParser.VariableDeclarationContext variableDeclarationContext) {
        if (this.checkForDuplicatedName(variableDeclarationContext.name.getText(), variableDeclarationContext)) {
            this.typeEnvironment.addLocation(variableDeclarationContext.name.getText(), MoonLightType.typeOf(variableDeclarationContext.type.getText()));
            this.symbols.put(variableDeclarationContext.name.getText(), variableDeclarationContext);
        }
    }

    private void recordScriptSignal(MoonLightScriptParser.ScriptSignalContext scriptSignal) {
        scriptSignal.signalVariables.forEach(this::recordSignalVariable);
    }

    private void recordSignalVariable(MoonLightScriptParser.VariableDeclarationContext variableDeclarationContext) {
        if (this.checkForDuplicatedName(variableDeclarationContext.name.getText(), variableDeclarationContext)) {
            this.typeEnvironment.addSignal(variableDeclarationContext.name.getText(), MoonLightType.typeOf(variableDeclarationContext.type.getText()));
            this.symbols.put(variableDeclarationContext.name.getText(), variableDeclarationContext);
        }
    }

    private void recordVariable(MoonLightScriptParser.VariableDeclarationContext variableDeclarationContext) {
    }

    private MoonLightType buildType(MoonLightScriptParser.BasicTypeContext type) {
        return null;
    }

    private void recordConstant(MoonLightScriptParser.ScriptConstantContext scriptConstantContext) {
        if (this.checkForDuplicatedName(scriptConstantContext.name.getText(), scriptConstantContext) && TypeChecker.checkType(this.errors, this.typeEnvironment, MoonLightType.REAL, scriptConstantContext.value)) {
            this.typeEnvironment.addConstant(scriptConstantContext.name.getText(), MoonLightType.REAL);
            this.symbols.put(scriptConstantContext.name.getText(), scriptConstantContext);
        }
    }

    private void recordCustomType(MoonLightScriptParser.ScriptTypeContext scriptTypeContext) {
        if (this.checkForDuplicatedName(scriptTypeContext.name.getText(), scriptTypeContext) && scriptTypeContext.elements.stream().allMatch(te -> this.checkForDuplicatedName(te.name.getText(), (ParserRuleContext)te))) {
            this.checkForDuplicatedName(scriptTypeContext.name.getText(), scriptTypeContext);
            scriptTypeContext.elements.forEach(te -> this.checkForDuplicatedName(te.name.getText(), (ParserRuleContext)te));
            this.typeEnvironment.recordType(scriptTypeContext);
            this.symbols.put(scriptTypeContext.name.getText(), scriptTypeContext);
            scriptTypeContext.elements.forEach(te -> this.symbols.put(te.name.getText(), (ParserRuleContext)te));
        }
    }

    private boolean checkForDuplicatedName(String name, ParserRuleContext declarationContext) {
        if (this.symbols.containsKey(name)) {
            this.errors.add(MoonLightParseError.nameAlreadyDeclared(name, this.symbols.get(name), declarationContext));
            return false;
        }
        return true;
    }

    public boolean isSpatial() {
        return this.isSpatial;
    }
}

