/*
 * Decompiled with CFR 0.152.
 */
package eu.quanticol.moonlight.script;

import eu.quanticol.moonlight.MoonLightScript;
import eu.quanticol.moonlight.MoonLightSpatialTemporalScript;
import eu.quanticol.moonlight.MoonLightTemporalScript;
import eu.quanticol.moonlight.SpatialTemporalMonitorDefinition;
import eu.quanticol.moonlight.SpatialTemporalMonitorProducer;
import eu.quanticol.moonlight.TemporalMonitorDefinition;
import eu.quanticol.moonlight.TemporalMonitorProducer;
import eu.quanticol.moonlight.core.io.DataHandler;
import eu.quanticol.moonlight.core.signal.SignalDomain;
import eu.quanticol.moonlight.domain.BooleanDomain;
import eu.quanticol.moonlight.domain.DoubleDomain;
import eu.quanticol.moonlight.offline.signal.RecordHandler;
import eu.quanticol.moonlight.script.DefaultNameResolver;
import eu.quanticol.moonlight.script.ExpressionEvaluator;
import eu.quanticol.moonlight.script.MoonLightEnumerationRepository;
import eu.quanticol.moonlight.script.MoonLightParseError;
import eu.quanticol.moonlight.script.MoonLightParserErrorListener;
import eu.quanticol.moonlight.script.MoonLightScriptLexer;
import eu.quanticol.moonlight.script.MoonLightScriptLoaderException;
import eu.quanticol.moonlight.script.MoonLightScriptParser;
import eu.quanticol.moonlight.script.ScriptValidator;
import eu.quanticol.moonlight.script.SpatialTemporalMonitoringGenerator;
import eu.quanticol.moonlight.script.TemporalMonitoringGenerator;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;

public class ScriptLoader {
    private final List<MoonLightParseError> errors;
    private final CharStream source;
    private MoonLightScriptParser.ModelContext model;
    private ScriptValidator validator;

    public static ScriptLoader loaderFromFile(String fileName) throws IOException {
        return new ScriptLoader(CharStreams.fromFileName((String)fileName));
    }

    public static ScriptLoader loaderFromCode(String code) throws IOException {
        return new ScriptLoader((CharStream)CharStreams.fromString((String)code));
    }

    public static MoonLightScript loadFromFile(String fileName) throws IOException, MoonLightScriptLoaderException {
        ScriptLoader loader = ScriptLoader.loaderFromFile(fileName);
        return loader.getScript();
    }

    public static MoonLightScript loadFromCode(String code) throws IOException, MoonLightScriptLoaderException {
        ScriptLoader loader = ScriptLoader.loaderFromCode(code);
        return loader.getScript();
    }

    public ScriptLoader(CharStream source) {
        this.source = source;
        this.errors = Collections.synchronizedList(new LinkedList());
    }

    public List<MoonLightParseError> getErrors() {
        return this.errors;
    }

    public boolean withErrors() {
        return !this.errors.isEmpty();
    }

    private boolean loadModel() {
        MoonLightScriptLexer lexer = new MoonLightScriptLexer(this.source);
        CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
        MoonLightScriptParser parser = new MoonLightScriptParser((TokenStream)tokens);
        parser.addErrorListener((ANTLRErrorListener)new MoonLightParserErrorListener(this.errors));
        this.model = parser.model();
        return this.errors.isEmpty();
    }

    private MoonLightScript loadScript() throws MoonLightScriptLoaderException {
        if (!this.loadModel() || !this.validate()) {
            throw new MoonLightScriptLoaderException(this.errors);
        }
        if (this.validator.isSpatial()) {
            return this.generateSpatialScript();
        }
        return this.generateTemporalScript();
    }

    private MoonLightScript generateSpatialScript() {
        MoonLightEnumerationRepository repository = this.getHandlers();
        Map<String, Double> constants = this.evalConstants(repository);
        RecordHandler signalHandler = this.getRecordHandler(repository, this.model.scriptSignal().signalVariables);
        RecordHandler edgeHandler = this.getRecordHandler(repository, this.model.scriptSpace().edgeVariables);
        SignalDomain<?> domain = this.getDomain();
        Map<String, RecordHandler> formulaParameters = this.getFormulaParameters(repository);
        HashMap<String, SpatialTemporalMonitorProducer> producers = new HashMap<String, SpatialTemporalMonitorProducer>();
        DefaultNameResolver resolver = new DefaultNameResolver(repository, constants);
        String defaultMonitor = null;
        for (MoonLightScriptParser.ScriptFormulaContext f : this.model.formulas) {
            SpatialTemporalMonitoringGenerator evaluator = new SpatialTemporalMonitoringGenerator(producers, resolver, formulaParameters, formulaParameters.get(f.name.getText()), signalHandler, edgeHandler);
            producers.put(f.name.getText(), evaluator.eval(f.formula));
            if (defaultMonitor != null && f.isDefault == null) continue;
            defaultMonitor = f.name.getText();
        }
        SpatialTemporalMonitorDefinition[] definitions = (SpatialTemporalMonitorDefinition[])producers.entrySet().stream().map(ke -> new SpatialTemporalMonitorDefinition((String)ke.getKey(), (RecordHandler)formulaParameters.get(ke.getKey()), signalHandler, edgeHandler, (SpatialTemporalMonitorProducer)producers.get(ke.getKey()))).toArray(SpatialTemporalMonitorDefinition[]::new);
        return new MoonLightSpatialTemporalScript(defaultMonitor, domain, definitions);
    }

    private MoonLightScript generateTemporalScript() {
        MoonLightEnumerationRepository repository = this.getHandlers();
        Map<String, Double> constants = this.evalConstants(repository);
        RecordHandler signalHandler = this.getRecordHandler(repository, this.model.scriptSignal().signalVariables);
        SignalDomain<?> domain = this.getDomain();
        Map<String, RecordHandler> formulaParameters = this.getFormulaParameters(repository);
        HashMap<String, TemporalMonitorProducer> producers = new HashMap<String, TemporalMonitorProducer>();
        DefaultNameResolver resolver = new DefaultNameResolver(repository, constants);
        String defaultMonitor = null;
        for (MoonLightScriptParser.ScriptFormulaContext f : this.model.formulas) {
            TemporalMonitoringGenerator evaluator = new TemporalMonitoringGenerator(producers, resolver, formulaParameters, formulaParameters.get(f.name.getText()), signalHandler);
            producers.put(f.name.getText(), evaluator.eval(f.formula));
            if (defaultMonitor != null && f.isDefault == null) continue;
            defaultMonitor = f.name.getText();
        }
        TemporalMonitorDefinition[] definitions = (TemporalMonitorDefinition[])producers.entrySet().stream().map(ke -> new TemporalMonitorDefinition((String)ke.getKey(), (RecordHandler)formulaParameters.get(ke.getKey()), signalHandler, (TemporalMonitorProducer)producers.get(ke.getKey()))).toArray(TemporalMonitorDefinition[]::new);
        return new MoonLightTemporalScript(defaultMonitor, domain, definitions);
    }

    private SignalDomain<?> getDomain() {
        String domainName = this.model.scriptDomain().semiring.getText();
        if (domainName.equals("minmax")) {
            return new DoubleDomain();
        }
        if (domainName.equals("boolean")) {
            return new BooleanDomain();
        }
        throw new IllegalStateException(String.format("Declared domain %s is unknown!", domainName));
    }

    private Map<String, RecordHandler> getFormulaParameters(MoonLightEnumerationRepository repository) {
        HashMap<String, RecordHandler> map = new HashMap<String, RecordHandler>();
        this.model.formulas.forEach(f -> {
            if (f.parameters != null && f.parameters.size() > 0) {
                map.put(f.name.getText(), this.getRecordHandler(repository, f.parameters));
            } else {
                map.put(f.name.getText(), new RecordHandler(new DataHandler[0]));
            }
        });
        return map;
    }

    private RecordHandler getRecordHandler(MoonLightEnumerationRepository repository, List<MoonLightScriptParser.VariableDeclarationContext> parameters) {
        DataHandler[] handlers = new DataHandler[parameters.size()];
        HashMap<String, Integer> indexes = new HashMap<String, Integer>();
        int counter = 0;
        for (MoonLightScriptParser.VariableDeclarationContext v : parameters) {
            indexes.put(v.name.getText(), counter);
            handlers[counter] = this.getHandler(repository, v.type);
            ++counter;
        }
        return new RecordHandler(indexes, handlers);
    }

    private DataHandler<?> getHandler(MoonLightEnumerationRepository repository, MoonLightScriptParser.BasicTypeContext type) {
        if (type instanceof MoonLightScriptParser.IntegerTypeContext) {
            return DataHandler.INTEGER;
        }
        if (type instanceof MoonLightScriptParser.RealTypeContext) {
            return DataHandler.REAL;
        }
        if (type instanceof MoonLightScriptParser.BooleanTypeContext) {
            return DataHandler.BOOLEAN;
        }
        if (type instanceof MoonLightScriptParser.ReferenceTypeContext) {
            return repository.getHandler(((MoonLightScriptParser.ReferenceTypeContext)type).type.getText());
        }
        return null;
    }

    private Map<String, Double> evalConstants(MoonLightEnumerationRepository repository) {
        HashMap<String, Double> values = new HashMap<String, Double>();
        for (MoonLightScriptParser.ScriptConstantContext c : this.model.constants) {
            ExpressionEvaluator ev = new ExpressionEvaluator(this.errors, new DefaultNameResolver(repository, values));
            double res = ev.eval(c.value);
            if (Double.isNaN(res)) continue;
            values.put(c.name.getText(), res);
        }
        return values;
    }

    private MoonLightEnumerationRepository getHandlers() {
        MoonLightEnumerationRepository repository = new MoonLightEnumerationRepository();
        for (MoonLightScriptParser.ScriptTypeContext customType : this.model.types) {
            repository.add(customType.name.getText(), (String[])customType.elements.stream().map(te -> te.name.getText()).toArray(String[]::new));
        }
        return repository;
    }

    private boolean validate() {
        this.validator = new ScriptValidator(this.errors);
        return this.validator.validate(this.model);
    }

    public MoonLightScript getScript() throws MoonLightScriptLoaderException {
        return this.loadScript();
    }
}

