/*
 * Decompiled with CFR 0.152.
 */
package eu.quanticol.moonlight.script;

import eu.quanticol.moonlight.core.base.MoonLightRecord;
import eu.quanticol.moonlight.core.io.DataHandler;
import eu.quanticol.moonlight.offline.signal.RecordHandler;
import eu.quanticol.moonlight.script.MoonLightParseError;
import eu.quanticol.moonlight.script.MoonLightScriptBaseVisitor;
import eu.quanticol.moonlight.script.MoonLightScriptParser;
import eu.quanticol.moonlight.script.NameResolver;
import eu.quanticol.moonlight.script.ParametricBooleanExpressionEvaluator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.antlr.v4.runtime.ParserRuleContext;

public class ParametricExpressionEvaluator
extends MoonLightScriptBaseVisitor<Function<MoonLightRecord, Double>> {
    private static final Map<String, BiFunction<Double, Double, Double>> binaryFunctionMap = new HashMap<String, BiFunction<Double, Double, Double>>();
    private static final Map<String, Function<Double, Double>> unaryFunctionMap;
    private final List<MoonLightParseError> errors;
    private final NameResolver nameResolver;
    private final RecordHandler inputHandler;
    private ParametricBooleanExpressionEvaluator booleanExpressionEvaluator;

    public ParametricExpressionEvaluator(List<MoonLightParseError> errors, NameResolver nameResolver, RecordHandler inputHandler) {
        this.errors = errors;
        this.nameResolver = nameResolver;
        this.inputHandler = inputHandler;
    }

    public ParametricExpressionEvaluator(NameResolver nameResolver, RecordHandler inputHandler) {
        this(new LinkedList<MoonLightParseError>(), nameResolver, inputHandler);
    }

    public ParametricExpressionEvaluator(NameResolver nameResolver) {
        this(nameResolver, new RecordHandler(new DataHandler[0]));
    }

    protected Function<MoonLightRecord, Double> defaultResult() {
        return r -> Double.NaN;
    }

    @Override
    public Function<MoonLightRecord, Double> visitBinaryMathCallExpression(MoonLightScriptParser.BinaryMathCallExpressionContext ctx) {
        BiFunction<Double, Double, Double> opFunction = this.getBinaryFunction(ctx.binaryMathFunction());
        return this.doApply(ctx, opFunction, (Function)ctx.left.accept(this), (Function)ctx.right.accept(this));
    }

    private BiFunction<Double, Double, Double> getBinaryFunction(MoonLightScriptParser.BinaryMathFunctionContext binaryMathFunction) {
        String funName = binaryMathFunction.getText();
        BiFunction<Double, Double, Double> fun = binaryFunctionMap.get(funName);
        if (fun == null) {
            this.errors.add(MoonLightParseError.illegalFunctionName(funName, binaryMathFunction.start));
            return (x, y) -> Double.NaN;
        }
        return fun;
    }

    private Function<MoonLightRecord, Double> doApply(ParserRuleContext ctx, BiFunction<Double, Double, Double> fun, Function<MoonLightRecord, Double> arg1, Function<MoonLightRecord, Double> arg2) {
        return r -> (Double)fun.apply((Double)arg1.apply((MoonLightRecord)r), (Double)arg2.apply((MoonLightRecord)r));
    }

    @Override
    public Function<MoonLightRecord, Double> visitBracketExpression(MoonLightScriptParser.BracketExpressionContext ctx) {
        return (Function)ctx.expression().accept(this);
    }

    @Override
    public Function<MoonLightRecord, Double> visitUnaryMathCallExpression(MoonLightScriptParser.UnaryMathCallExpressionContext ctx) {
        Function<Double, Double> fun = this.getUnaryFunction(ctx.fun);
        return this.doApply(ctx, fun, (Function)ctx.argument.accept(this));
    }

    private Function<MoonLightRecord, Double> doApply(ParserRuleContext ctx, Function<Double, Double> fun, Function<MoonLightRecord, Double> arg) {
        return r -> (Double)fun.apply((Double)arg.apply((MoonLightRecord)r));
    }

    private Function<Double, Double> getUnaryFunction(MoonLightScriptParser.UnaryMathFunctionContext unaryMathFunction) {
        String funName = unaryMathFunction.getText();
        Function<Double, Double> fun = unaryFunctionMap.get(funName);
        if (fun == null) {
            this.errors.add(MoonLightParseError.illegalFunctionName(funName, unaryMathFunction.start));
            return x -> Double.NaN;
        }
        return fun;
    }

    @Override
    public Function<MoonLightRecord, Double> visitRealExpression(MoonLightScriptParser.RealExpressionContext ctx) {
        double v = Double.parseDouble(ctx.getText());
        return r -> v;
    }

    @Override
    public Function<MoonLightRecord, Double> visitUnaryExpression(MoonLightScriptParser.UnaryExpressionContext ctx) {
        if (ctx.op.getText().equals("-")) {
            return this.doApply(ctx, x -> -x.doubleValue(), (Function)ctx.arg.accept(this));
        }
        return (Function)ctx.arg.accept(this);
    }

    @Override
    public Function<MoonLightRecord, Double> visitReferenceExpression(MoonLightScriptParser.ReferenceExpressionContext ctx) {
        String name = ctx.name.getText();
        double value = this.nameResolver.get(name);
        if (!Double.isNaN(value)) {
            return r -> value;
        }
        if (this.inputHandler.isAVariable(name)) {
            int idx = this.inputHandler.getVariableIndex(name);
            return r -> r.getDoubleOf(idx);
        }
        return r -> Double.NaN;
    }

    @Override
    public Function<MoonLightRecord, Double> visitIntExpression(MoonLightScriptParser.IntExpressionContext ctx) {
        double value = Integer.parseInt(ctx.getText());
        return r -> value;
    }

    @Override
    public Function<MoonLightRecord, Double> visitIfThenElseExpression(MoonLightScriptParser.IfThenElseExpressionContext ctx) {
        ParametricBooleanExpressionEvaluator booleanEvaluator = this.getParametricBooleanExpressionEvaluator();
        if (booleanEvaluator.eval(ctx.guard)) {
            return (Function)ctx.thenExpression.accept(this);
        }
        return (Function)ctx.elseExpression.accept(this);
    }

    private synchronized ParametricBooleanExpressionEvaluator getParametricBooleanExpressionEvaluator() {
        if (this.booleanExpressionEvaluator == null) {
            this.booleanExpressionEvaluator = new ParametricBooleanExpressionEvaluator(this);
        }
        return this.booleanExpressionEvaluator;
    }

    @Override
    public Function<MoonLightRecord, Double> visitMulDivExpression(MoonLightScriptParser.MulDivExpressionContext ctx) {
        BiFunction<Double, Double, Double> fun = ctx.op.getText().equals("*") ? (x, y) -> x * y : (x, y) -> x / y;
        return this.doApply(ctx, fun, (Function)ctx.left.accept(this), (Function)ctx.right.accept(this));
    }

    @Override
    public Function<MoonLightRecord, Double> visitSumDifExpression(MoonLightScriptParser.SumDifExpressionContext ctx) {
        BiFunction<Double, Double, Double> fun = ctx.op.getText().equals("+") ? Double::sum : (ctx.op.getText().equals("-") ? (x, y) -> x - y : (x, y) -> x % y);
        return this.doApply(ctx, fun, (Function)ctx.left.accept(this), (Function)ctx.right.accept(this));
    }

    @Override
    public Function<MoonLightRecord, Double> visitInfinityExpression(MoonLightScriptParser.InfinityExpressionContext ctx) {
        return r -> Double.POSITIVE_INFINITY;
    }

    public Function<MoonLightRecord, Double> eval(MoonLightScriptParser.ExpressionContext value) {
        return (Function)value.accept(this);
    }

    static {
        binaryFunctionMap.put("atan2", Math::atan2);
        binaryFunctionMap.put("hypot", Math::hypot);
        binaryFunctionMap.put("max", Math::max);
        binaryFunctionMap.put("min", Math::min);
        binaryFunctionMap.put("pow", Math::pow);
        unaryFunctionMap = new HashMap<String, Function<Double, Double>>();
        unaryFunctionMap.put("abs", Math::abs);
        unaryFunctionMap.put("acos", Math::acos);
        unaryFunctionMap.put("asin", Math::asin);
        unaryFunctionMap.put("atan", Math::atan);
        unaryFunctionMap.put("cbrt", Math::cbrt);
        unaryFunctionMap.put("ceil", Math::ceil);
        unaryFunctionMap.put("cos", Math::cos);
        unaryFunctionMap.put("cosh", Math::cosh);
        unaryFunctionMap.put("exp", Math::exp);
        unaryFunctionMap.put("expm1", Math::expm1);
        unaryFunctionMap.put("floor", Math::floor);
        unaryFunctionMap.put("log", Math::log);
        unaryFunctionMap.put("log10", Math::log10);
        unaryFunctionMap.put("log1p", Math::log1p);
        unaryFunctionMap.put("signum", Math::signum);
        unaryFunctionMap.put("sin", Math::sin);
        unaryFunctionMap.put("sqrt", Math::sqrt);
        unaryFunctionMap.put("sinh", Math::sinh);
        unaryFunctionMap.put("tan", Math::tan);
    }
}

