/*
 * Decompiled with CFR 0.152.
 */
package eu.quanticol.moonlight.script;

import eu.quanticol.moonlight.offline.signal.EnumerationHandler;
import java.util.HashMap;
import java.util.Map;

public class MoonLightEnumerationRepository {
    private final Map<String, EnumerationHandler<String>> archive;
    private final Map<String, Integer> indexesOfElements;

    public MoonLightEnumerationRepository(Map<String, EnumerationHandler<String>> archive, Map<String, Integer> indexesOfElements) {
        this.archive = archive;
        this.indexesOfElements = indexesOfElements;
    }

    public MoonLightEnumerationRepository() {
        this(new HashMap<String, EnumerationHandler<String>>(), new HashMap<String, Integer>());
    }

    public void add(String name, String[] elements) {
        EnumerationHandler handler = new EnumerationHandler(String.class, (Object[])elements);
        this.archive.put(name, (EnumerationHandler<String>)handler);
        for (String e : elements) {
            this.indexesOfElements.put(e, handler.indexOf((Object)e));
        }
    }

    public EnumerationHandler<String> getHandler(String name) {
        return this.archive.get(name);
    }

    public int valueOf(String element) {
        return this.indexesOfElements.getOrDefault(element, -1);
    }
}

