/*
 * Decompiled with CFR 0.152.
 */
package eu.quanticol.moonlight.online.algorithms;

import eu.quanticol.moonlight.core.base.Pair;
import eu.quanticol.moonlight.core.signal.SignalDomain;
import eu.quanticol.moonlight.core.space.DistanceStructure;
import eu.quanticol.moonlight.core.space.LocationService;
import eu.quanticol.moonlight.core.space.SpatialModel;
import eu.quanticol.moonlight.offline.signal.SpatialTemporalSignal;
import java.util.Iterator;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;

public class ReachOperator<T extends Comparable<T>, S, R extends Comparable<R>> {
    private final LocationService<T, S> locSvc;
    private final Function<SpatialModel<S>, DistanceStructure<S, ?>> dist;
    Iterator<Pair<T, SpatialModel<S>>> spaceItr;
    Pair<T, SpatialModel<S>> currSpace;
    Pair<T, SpatialModel<S>> nextSpace;

    public ReachOperator(@NotNull LocationService<T, S> locationService, Function<SpatialModel<S>, DistanceStructure<S, ?>> distance, SignalDomain<R> domain, SpatialTemporalSignal<R> s1, SpatialTemporalSignal<R> s2) {
        this.checkLocationServiceValidity(locationService);
        this.locSvc = locationService;
        this.dist = distance;
    }

    private void checkLocationServiceValidity(LocationService<T, S> locSvc) {
        if (locSvc.isEmpty()) {
            throw new UnsupportedOperationException("The location Service must not be empty!");
        }
    }

    private static <S> Pair<Double, SpatialModel<S>> getNext(Iterator<Pair<Double, SpatialModel<S>>> iter) {
        return iter.hasNext() ? iter.next() : null;
    }
}

