/*
 * Decompiled with CFR 0.152.
 */
package eu.quanticol.moonlight.offline.signal;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Stream;

public interface SignalCursor<T, V> {
    public static <C> boolean isNotCompleted(List<SignalCursor<Double, C>> cursors) {
        return SignalCursor.isNotCompleted(cursors.stream());
    }

    private static <C> boolean isNotCompleted(Stream<SignalCursor<Double, C>> cursors) {
        return cursors.map(c -> !c.isCompleted()).reduce(true, (c1, c2) -> c1 != false && c2 != false);
    }

    public boolean isCompleted();

    @SafeVarargs
    public static <C> boolean isNotCompleted(SignalCursor<Double, C> ... cursors) {
        return SignalCursor.isNotCompleted(Arrays.stream(cursors));
    }

    public T getCurrentTime();

    public V getCurrentValue();

    public void forward();

    public void backward();

    public void revert();

    public void move(T var1);

    public T nextTime();

    public T previousTime();

    public boolean hasNext();

    public boolean hasPrevious();
}

