/*
 * Decompiled with CFR 0.152.
 */
package eu.quanticol.moonlight.offline.signal;

import eu.quanticol.moonlight.core.base.Pair;
import eu.quanticol.moonlight.core.signal.TimeSignal;
import eu.quanticol.moonlight.offline.signal.OfflineSignalCursor;
import eu.quanticol.moonlight.offline.signal.Segment;
import eu.quanticol.moonlight.offline.signal.SignalCursor;
import eu.quanticol.moonlight.online.signal.TimeChain;
import eu.quanticol.moonlight.online.signal.Update;
import java.util.HashSet;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.ToDoubleFunction;

public class Signal<T>
implements TimeSignal<Double, T> {
    private Segment<T> first = null;
    private Segment<T> last = null;
    private int size = 0;

    public double getStart() {
        return Segment.getTime(this.first);
    }

    public double getEnd() {
        return this.last.getEnd();
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public void add(double t, T value) {
        Segment<T> oldLast = this.last;
        if (this.first == null) {
            this.startWith(t, value);
        } else {
            if (this.getEnd() > t) {
                this.badEnding(t);
            }
            this.last = this.last.addAfter(t, value);
        }
        if (oldLast != this.last) {
            ++this.size;
        }
    }

    private void badEnding(double t) {
        throw new IllegalArgumentException("Trying to define an illegal ending time:" + t + "; which is before the current end of the signal: " + this.getEnd());
    }

    private void startWith(double t, T value) {
        this.first = new Segment<T>(t, value);
        this.last = this.first;
    }

    public void addBefore(double t, T value) {
        Segment<T> oldFirst = this.first;
        if (this.first == null) {
            this.startWith(t, value);
        } else {
            this.first = this.first.addBefore(t, value);
        }
        if (this.first != oldFirst) {
            ++this.size;
        }
    }

    public void forEach(BiConsumer<Double, T> consumer) {
        SignalCursor<Double, T> cursor = this.getIterator(true);
        while (!cursor.isCompleted()) {
            consumer.accept(cursor.getCurrentTime(), (Double)cursor.getCurrentValue());
            cursor.forward();
        }
    }

    public <R> R reduce(BiFunction<Pair<Double, T>, R, R> reducer, R init) {
        R toReturn = init;
        SignalCursor<Double, T> cursor = this.getIterator(true);
        while (!cursor.isCompleted()) {
            toReturn = reducer.apply(new Pair<Double, T>(cursor.getCurrentTime(), cursor.getCurrentValue()), toReturn);
            cursor.forward();
        }
        return toReturn;
    }

    public <R> void fill(double[] timePoints, R[] data, Function<T, R> f) {
        if (this.size == 0) {
            throw new IllegalStateException("No array can be generated from an empty signal is empty!");
        }
        Segment<T> current = this.first;
        for (int i = 0; i < timePoints.length; ++i) {
            current = current.jump(timePoints[i]);
            data[i] = f.apply(current.getValue());
        }
    }

    public SignalCursor<Double, T> getIterator(boolean forward) {
        return new OfflineSignalCursor<T>(forward, this.first, this.last);
    }

    public int size() {
        return this.size;
    }

    public String toString() {
        if (this.isEmpty()) {
            return "Signal [ ]";
        }
        return "Signal [start=" + this.getStart() + ", end=" + this.getEnd() + ", size=" + this.size() + "]";
    }

    public void endAt(double end) {
        if (this.getEnd() > end || this.last == null) {
            this.badEnding(end);
        }
        this.last.endAt(end);
    }

    @Override
    public T getValueAt(Double time) {
        return this.first == null ? null : (T)this.first.getValueAt(time);
    }

    public double[][] arrayOf(ToDoubleFunction<T> f) {
        if (this.size == 0) {
            return new double[0][];
        }
        int arraySize = this.size;
        if (!this.last.isAPoint()) {
            ++arraySize;
        }
        double[][] toReturn = new double[arraySize][2];
        Segment<T> current = this.first;
        int counter = 0;
        while (current != null) {
            toReturn[counter][0] = current.getStart();
            toReturn[counter][1] = f.applyAsDouble(current.getValue());
            current = current.getNext();
            ++counter;
        }
        if (!this.last.isAPoint()) {
            toReturn[this.size][0] = this.getEnd();
            toReturn[this.size][1] = f.applyAsDouble(this.last.getValue());
        }
        return toReturn;
    }

    public double[][] arrayOf(double[] timePoints, ToDoubleFunction<T> f) {
        if (this.size == 0) {
            return new double[0][];
        }
        double[][] toReturn = new double[timePoints.length][2];
        Segment<T> current = this.first;
        double value = Double.NaN;
        for (int i = 0; i < timePoints.length; ++i) {
            if (current != null) {
                current = current.jump(timePoints[i]);
            }
            if (current != null) {
                value = f.applyAsDouble(current.getValue());
            }
            toReturn[i][0] = timePoints[i];
            toReturn[i][1] = value;
        }
        return toReturn;
    }

    public Set<Double> getTimeSet() {
        HashSet<Double> timeSet = new HashSet<Double>();
        for (Segment<T> current = this.first; current != null; current = current.getNext()) {
            timeSet.add(current.getStart());
        }
        timeSet.add(this.getEnd());
        return timeSet;
    }

    @Override
    public boolean refine(Update<Double, T> u) {
        throw new UnsupportedOperationException("Refinements are not implemented yet for offline signals");
    }

    @Override
    public boolean refine(TimeChain<Double, T> updates) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Refinements are not implemented yet for offline signals");
    }

    @Override
    public TimeChain<Double, T> getSegments() {
        throw new UnsupportedOperationException("Segment extraction is not implemented yet for offline signals");
    }

    @Override
    public TimeChain<Double, T> select(Double from, Double to) {
        throw new UnsupportedOperationException("Selection is not implemented yet for offline signals");
    }
}

