/*
 * Decompiled with CFR 0.152.
 */
package eu.quanticol.moonlight.offline.signal;

import eu.quanticol.moonlight.core.base.MoonLightRecord;
import eu.quanticol.moonlight.core.base.Pair;
import eu.quanticol.moonlight.core.io.DataHandler;
import eu.quanticol.moonlight.offline.signal.IllegalValueException;
import eu.quanticol.moonlight.offline.signal.Signal;
import eu.quanticol.moonlight.offline.signal.SpatialTemporalSignal;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class RecordHandler
implements DataHandler<MoonLightRecord> {
    private DataHandler<?>[] handlers;
    private Map<String, Integer> variables;

    public RecordHandler(DataHandler<?> ... varTypes) {
        this(new HashMap<String, Integer>(), varTypes);
    }

    public RecordHandler(Map<String, Integer> variableIndex, DataHandler<?> ... varTypes) {
        this.handlers = Arrays.copyOf(varTypes, varTypes.length);
        this.variables = variableIndex;
    }

    @SafeVarargs
    public static RecordHandler createFactory(Pair<String, DataHandler<?>> ... variables) {
        DataHandler[] dataHandlers = new DataHandler[variables.length];
        HashMap<String, Integer> variableIndex = new HashMap<String, Integer>();
        int counter = 0;
        for (Pair<String, DataHandler<?>> p : variables) {
            dataHandlers[counter] = p.getSecond();
            if (variableIndex.put(p.getFirst(), counter++) == null) continue;
            throw new IllegalArgumentException("Duplicated variable " + p.getFirst() + "!");
        }
        return new RecordHandler(variableIndex, dataHandlers);
    }

    public MoonLightRecord fromObjectArray(Object ... values) {
        if (values.length != this.handlers.length) {
            throw new IllegalArgumentException("Wrong data size! (Expected " + this.handlers.length + " is " + values.length);
        }
        Object[] data = new Object[values.length];
        for (int i = 0; i < values.length; ++i) {
            data[i] = this.handlers[i].fromObject(values[i]);
        }
        return this.build(data);
    }

    public MoonLightRecord fromDoubleArray(Double[] values) {
        return this.fromDoubleArray(values, 0, values.length);
    }

    public MoonLightRecord fromDoubleArray(double ... values) {
        return this.fromDoubleArray(values, 0, values.length);
    }

    public MoonLightRecord fromDoubleArray(double[] values, int from, int to) {
        if (to - from != this.handlers.length) {
            throw new IllegalArgumentException("Wrong data size! (Expected " + this.handlers.length + " is " + (to - from));
        }
        Object[] data = new Object[this.handlers.length];
        for (int i = 0; i < this.handlers.length; ++i) {
            data[i] = this.handlers[i].fromDouble(values[i + from]);
        }
        return this.build(data);
    }

    public MoonLightRecord fromDoubleArray(Double[] values, int from, int to) {
        if (to - from != this.handlers.length) {
            throw new IllegalArgumentException("Wrong data size! (Expected " + this.handlers.length + " is " + (to - from));
        }
        Object[] data = new Object[this.handlers.length];
        for (int i = 0; i < this.handlers.length; ++i) {
            data[i] = this.handlers[i].fromDouble(values[i + from]);
        }
        return this.build(data);
    }

    private MoonLightRecord build(Object[] values) {
        if (values.length != this.handlers.length) {
            throw new IllegalArgumentException();
        }
        return new MoonLightRecord(i -> this.handlers[i], values);
    }

    public MoonLightRecord fromStringArray(String ... values) {
        return this.fromStringArray(values, 0, values.length);
    }

    public MoonLightRecord fromStringArray(String[] values, int from, int to) {
        if (to - from != this.handlers.length) {
            throw new IllegalArgumentException("Wrong data size! (Expected " + this.handlers.length + " is " + (to - from) + ")");
        }
        Object[] data = new Object[this.handlers.length];
        for (int i = 0; i < this.handlers.length; ++i) {
            data[i] = this.handlers[i].fromString(values[i + from]);
        }
        return this.build(data);
    }

    public MoonLightRecord fromObjectArray(Map<String, Object> values) throws IllegalValueException {
        this.checkNumberOfVariables(values.size());
        Object[] data = new Object[this.handlers.length];
        for (Map.Entry<String, Object> entry : values.entrySet()) {
            String v = entry.getKey();
            Object o = entry.getValue();
            int variableIndex = this.getVariableIndex(v);
            if (variableIndex < 0) {
                this.throwUnknownVariableException(v);
            }
            DataHandler<?> handler = this.handlers[variableIndex];
            data[variableIndex] = handler.fromObject(o);
        }
        return this.build(data);
    }

    private void throwUnknownVariableException(String v) {
        throw new IllegalArgumentException("Unknown variable " + v);
    }

    private void throwVariableTypeException(String v, String expected, String actual) {
        throw new IllegalArgumentException("Wrong data type for variable" + v + "; expected " + expected + " is " + actual);
    }

    public int getVariableIndex(String v) {
        return this.variables.getOrDefault(v, -1);
    }

    public MoonLightRecord fromStringArray(Map<String, String> values) throws IllegalValueException {
        this.checkNumberOfVariables(values.size());
        Object[] data = new Object[this.handlers.length];
        for (Map.Entry<String, String> entry : values.entrySet()) {
            String v = entry.getKey();
            String o = entry.getValue();
            int variableIndex = this.getVariableIndex(v);
            if (variableIndex < 0) {
                this.throwUnknownVariableException(v);
            }
            DataHandler<?> handler = this.handlers[variableIndex];
            data[variableIndex] = handler.fromString(o);
        }
        return this.build(data);
    }

    public MoonLightRecord fromDoubleArray(Map<String, Double> values) throws IllegalValueException {
        this.checkNumberOfVariables(values.size());
        Object[] data = new Object[this.handlers.length];
        for (Map.Entry<String, Double> entry : values.entrySet()) {
            String v = entry.getKey();
            Double d = entry.getValue();
            int variableIndex = this.getVariableIndex(v);
            if (variableIndex < 0) {
                this.throwUnknownVariableException(v);
            }
            DataHandler<?> handler = this.handlers[variableIndex];
            data[variableIndex] = handler.fromDouble(d);
        }
        return this.build(data);
    }

    public boolean checkNumberOfVariables(int size) {
        if (size != this.variables.size()) {
            throw new IllegalArgumentException("Wrong number of variables! (Expected " + this.handlers.length + " is " + size + ")");
        }
        return true;
    }

    public boolean checkVariableType(String v, String type) {
        int variableIndex = this.getVariableIndex(v);
        return variableIndex >= 0;
    }

    public Map<String, Integer> getVariableIndex() {
        return this.variables;
    }

    public int size() {
        return this.handlers.length;
    }

    public String getTypeCode(String name) {
        int variableIndex = this.getVariableIndex(name);
        if (variableIndex < 0) {
            return null;
        }
        return "";
    }

    public String[] getVariables() {
        return this.variables.keySet().toArray(new String[this.variables.size()]);
    }

    public boolean checkValueFromString(String v, String value) {
        int variableIndex = this.getVariableIndex(v);
        if (variableIndex < 0) {
            return false;
        }
        return this.handlers[variableIndex].checkStringValue(value);
    }

    public boolean checkValuesFromStrings(String[] values) {
        return this.checkValuesFromStrings(values, 0, values.length);
    }

    public boolean checkValuesFromStrings(String[] values, int from, int to) {
        if (to - from != this.handlers.length) {
            return false;
        }
        for (int i = 0; i < this.handlers.length; ++i) {
            if (this.handlers[i].checkStringValue(values[i + from])) continue;
            System.out.println(Arrays.toString(values));
            return false;
        }
        return true;
    }

    public static Signal<MoonLightRecord> buildTemporalSignal(RecordHandler handler, double[] time, String[][] signal) throws IllegalValueException {
        Signal<MoonLightRecord> toReturn = new Signal<MoonLightRecord>();
        for (int i = 0; i < time.length; ++i) {
            toReturn.add(time[i], handler.fromStringArray(signal[i]));
        }
        return toReturn;
    }

    public static Signal<MoonLightRecord> buildTemporalSignal(RecordHandler handler, double[] time, double[][] signal) {
        Signal<MoonLightRecord> toReturn = new Signal<MoonLightRecord>();
        for (int i = 0; i < time.length; ++i) {
            toReturn.add(time[i], handler.fromDoubleArray(signal[i]));
        }
        return toReturn;
    }

    public static SpatialTemporalSignal<MoonLightRecord> buildSpatioTemporalSignal(int size, RecordHandler handler, double[] time, String[][][] signal) {
        return new SpatialTemporalSignal<MoonLightRecord>(size, i -> RecordHandler.buildTemporalSignal(handler, time, signal[i]));
    }

    public static SpatialTemporalSignal<MoonLightRecord> buildSpatioTemporalSignal(int size, RecordHandler handler, double[] time, double[][][] signal) {
        return new SpatialTemporalSignal<MoonLightRecord>(size, i -> RecordHandler.buildTemporalSignal(handler, time, signal[i]));
    }

    @Override
    public Class<MoonLightRecord> getTypeOf() {
        return MoonLightRecord.class;
    }

    @Override
    public MoonLightRecord fromObject(Object o) {
        if (o == null) {
            throw new NullPointerException();
        }
        if (o instanceof MoonLightRecord) {
            MoonLightRecord r = (MoonLightRecord)o;
            Object[] values = r.getValues();
            if (this.checkValues(values)) {
                return this.build(values);
            }
            throw new IllegalValueException("Illegal data type!");
        }
        throw new IllegalValueException("A record is espected. Here we have " + o.getClass().getName());
    }

    private boolean checkValues(Object[] values) {
        int i;
        if (this.handlers.length == values.length && (i = 0) < values.length) {
            return this.handlers[i].checkObjectValue(values[i]);
        }
        return false;
    }

    @Override
    public MoonLightRecord fromString(String str) {
        String[] data = str.split(";");
        return this.fromStringArray(data);
    }

    @Override
    public MoonLightRecord fromDouble(double value) {
        throw new IllegalValueException("A record cannot be built from a double!");
    }

    @Override
    public String stringOf(MoonLightRecord record) {
        return record.toString();
    }

    @Override
    public double doubleOf(Object record) {
        return Double.NaN;
    }

    @Override
    public boolean checkObjectValue(Object o) {
        if (o instanceof MoonLightRecord) {
            MoonLightRecord r = (MoonLightRecord)o;
            Object[] values = r.getValues();
            return this.checkValues(values);
        }
        return false;
    }

    @Override
    public boolean checkStringValue(String value) {
        return this.checkValuesFromStrings(value.split(";"));
    }

    @Override
    public boolean checkDoubleValue(double value) {
        return false;
    }

    public boolean isAVariable(String name) {
        return this.variables.containsKey(name);
    }
}

