/*
 * Decompiled with CFR 0.152.
 */
package eu.quanticol.moonlight.offline.signal;

import eu.quanticol.moonlight.core.io.DataHandler;
import eu.quanticol.moonlight.offline.signal.IllegalValueException;
import java.util.HashMap;

public class EnumerationHandler<T>
implements DataHandler<T> {
    private final T[] values;
    private final Class<T> type;
    private final HashMap<String, T> stringMap;
    private final HashMap<T, Integer> indexOf;

    public EnumerationHandler(Class<T> type, T[] values) {
        this.values = values;
        this.type = type;
        this.stringMap = new HashMap();
        this.indexOf = new HashMap();
        this.initStringMap();
        this.initIndexMap();
    }

    private void initIndexMap() {
        for (int i = 0; i < this.values.length; ++i) {
            this.indexOf.put(this.values[i], i);
        }
    }

    private void initStringMap() {
        for (T t : this.values) {
            this.stringMap.put(t.toString(), t);
        }
    }

    @Override
    public Class<T> getTypeOf() {
        return this.type;
    }

    @Override
    public T fromObject(Object o) {
        if (this.type.isInstance(o)) {
            return this.type.cast(o);
        }
        throw new IllegalValueException("Expected " + this.type.getName() + " was " + o);
    }

    @Override
    public T fromString(String str) {
        T value = this.stringMap.get(str);
        if (value != null) {
            return value;
        }
        throw new IllegalValueException("Unknown value " + str);
    }

    @Override
    public T fromDouble(double value) {
        int intValue = (int)value;
        if (intValue < 0 || intValue >= this.values.length) {
            throw new IllegalValueException("Illegal index " + value);
        }
        return this.values[intValue];
    }

    @Override
    public String stringOf(T t) {
        return t.toString();
    }

    @Override
    public double doubleOf(Object t) {
        if (this.type.isInstance(t)) {
            return this.indexOf(this.type.cast(t));
        }
        return Double.NaN;
    }

    public int indexOf(T t) {
        return this.indexOf.getOrDefault(t, -1);
    }

    @Override
    public boolean checkObjectValue(Object o) {
        return this.type.isInstance(o) && this.indexOf.containsKey(o);
    }

    @Override
    public boolean checkStringValue(String value) {
        return this.stringMap.containsKey(value);
    }

    @Override
    public boolean checkDoubleValue(double value) {
        int intValue = (int)value;
        return intValue < 0 || intValue >= this.values.length;
    }
}

