/*
 * Decompiled with CFR 0.152.
 */
package eu.quanticol.moonlight.offline.monitoring.spatialtemporal;

import eu.quanticol.moonlight.core.formula.Interval;
import eu.quanticol.moonlight.core.signal.SignalDomain;
import eu.quanticol.moonlight.core.space.LocationService;
import eu.quanticol.moonlight.offline.algorithms.TemporalOp;
import eu.quanticol.moonlight.offline.monitoring.spatialtemporal.SpatialTemporalMonitor;
import eu.quanticol.moonlight.offline.signal.SpatialTemporalSignal;

public class SpatialTemporalMonitorSince<S, T, R>
implements SpatialTemporalMonitor<S, T, R> {
    private final SpatialTemporalMonitor<S, T, R> m1;
    private final SpatialTemporalMonitor<S, T, R> m2;
    private final Interval interval;
    private final SignalDomain<R> domain;

    public SpatialTemporalMonitorSince(SpatialTemporalMonitor<S, T, R> m1, Interval interval, SpatialTemporalMonitor<S, T, R> m2, SignalDomain<R> domain) {
        this.m1 = m1;
        this.m2 = m2;
        this.interval = interval;
        this.domain = domain;
    }

    @Override
    public SpatialTemporalSignal<R> monitor(LocationService<Double, S> locationService, SpatialTemporalSignal<T> signal) {
        SpatialTemporalSignal left = this.m1.monitor(locationService, signal);
        SpatialTemporalSignal<R> right = this.m2.monitor(locationService, signal);
        return left.applyToSignal(right, (s1, s2) -> TemporalOp.computeSince(this.domain, s1, this.interval, s2));
    }
}

