/*
 * Decompiled with CFR 0.152.
 */
package eu.quanticol.moonlight.offline.monitoring.spatialtemporal;

import eu.quanticol.moonlight.core.algorithms.SpatialAlgorithms;
import eu.quanticol.moonlight.core.signal.SignalDomain;
import eu.quanticol.moonlight.core.space.DistanceStructure;
import eu.quanticol.moonlight.core.space.LocationService;
import eu.quanticol.moonlight.core.space.SpatialModel;
import eu.quanticol.moonlight.offline.monitoring.spatialtemporal.SpatialBinaryOp;
import eu.quanticol.moonlight.offline.monitoring.spatialtemporal.SpatialTemporalMonitor;
import eu.quanticol.moonlight.offline.signal.SpatialTemporalSignal;
import java.util.function.Function;
import java.util.function.IntFunction;

public class SpatialTemporalMonitorReach<S, T, R>
implements SpatialTemporalMonitor<S, T, R> {
    private final SpatialTemporalMonitor<S, T, R> m1;
    private final Function<SpatialModel<S>, DistanceStructure<S, ?>> distance;
    private final SpatialTemporalMonitor<S, T, R> m2;
    private final SignalDomain<R> domain;

    public SpatialTemporalMonitorReach(SpatialTemporalMonitor<S, T, R> m1, Function<SpatialModel<S>, DistanceStructure<S, ?>> distance, SpatialTemporalMonitor<S, T, R> m2, SignalDomain<R> domain) {
        this.m1 = m1;
        this.distance = distance;
        this.m2 = m2;
        this.domain = domain;
    }

    @Override
    public SpatialTemporalSignal<R> monitor(LocationService<Double, S> locationService, SpatialTemporalSignal<T> signal) {
        SpatialBinaryOp<S, R> sp = new SpatialBinaryOp<S, R>(locationService, this.distance, this.domain);
        return sp.computeReach(this.m1.monitor(locationService, signal), this.m2.monitor(locationService, signal));
    }

    private IntFunction<R> reachOp(IntFunction<R> leftSignal, IntFunction<R> rightSignal, DistanceStructure<S, ?> ds) {
        return SpatialAlgorithms.reach(this.domain, leftSignal, rightSignal, ds);
    }
}

