/*
 * Decompiled with CFR 0.152.
 */
package eu.quanticol.moonlight.offline.monitoring;

import eu.quanticol.moonlight.core.formula.Formula;
import eu.quanticol.moonlight.core.formula.Interval;
import eu.quanticol.moonlight.core.signal.SignalDomain;
import eu.quanticol.moonlight.formula.AtomicFormula;
import eu.quanticol.moonlight.formula.Parameters;
import eu.quanticol.moonlight.formula.classic.AndFormula;
import eu.quanticol.moonlight.formula.classic.NegationFormula;
import eu.quanticol.moonlight.formula.classic.OrFormula;
import eu.quanticol.moonlight.formula.temporal.EventuallyFormula;
import eu.quanticol.moonlight.formula.temporal.GloballyFormula;
import eu.quanticol.moonlight.formula.temporal.HistoricallyFormula;
import eu.quanticol.moonlight.formula.temporal.OnceFormula;
import eu.quanticol.moonlight.formula.temporal.SinceFormula;
import eu.quanticol.moonlight.formula.temporal.UntilFormula;
import eu.quanticol.moonlight.offline.monitoring.temporal.TemporalMonitor;
import java.lang.runtime.SwitchBootstraps;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;

public class TemporalMonitoring<T, R> {
    private final Map<String, Function<Parameters, Function<T, R>>> atoms;
    private final SignalDomain<R> module;

    public TemporalMonitoring(SignalDomain<R> interpretation) {
        this(new HashMap<String, Function<Parameters, Function<T, R>>>(), interpretation);
    }

    public TemporalMonitoring(Map<String, Function<Parameters, Function<T, R>>> atomicPropositions, SignalDomain<R> interpretation) {
        this.atoms = atomicPropositions;
        this.module = interpretation;
    }

    public void addProperty(String name, Function<Parameters, Function<T, R>> atomicFunction) {
        this.atoms.put(name, atomicFunction);
    }

    public TemporalMonitor<T, R> monitor(Formula f) {
        Formula formula = f;
        Objects.requireNonNull(formula);
        Formula formula2 = formula;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{AtomicFormula.class, NegationFormula.class, AndFormula.class, OrFormula.class, EventuallyFormula.class, GloballyFormula.class, UntilFormula.class, OnceFormula.class, HistoricallyFormula.class, SinceFormula.class}, (Object)formula2, n)) {
            case 0 -> {
                AtomicFormula atomic = (AtomicFormula)formula2;
                yield this.generateAtomicMonitor(atomic);
            }
            case 1 -> {
                NegationFormula negation = (NegationFormula)formula2;
                yield this.generateNegationMonitor(negation);
            }
            case 2 -> {
                AndFormula and = (AndFormula)formula2;
                yield this.generateAndMonitor(and);
            }
            case 3 -> {
                OrFormula or = (OrFormula)formula2;
                yield this.generateOrMonitor(or);
            }
            case 4 -> {
                EventuallyFormula ev = (EventuallyFormula)formula2;
                yield this.generateEventuallyMonitor(ev);
            }
            case 5 -> {
                GloballyFormula globally = (GloballyFormula)formula2;
                yield this.generateGloballyMonitor(globally);
            }
            case 6 -> {
                UntilFormula until = (UntilFormula)formula2;
                yield this.generateUntilMonitor(until);
            }
            case 7 -> {
                OnceFormula once = (OnceFormula)formula2;
                yield this.generateOnceMonitor(once);
            }
            case 8 -> {
                HistoricallyFormula hs = (HistoricallyFormula)formula2;
                yield this.generateHistoricallyMonitor(hs);
            }
            case 9 -> {
                SinceFormula since = (SinceFormula)formula2;
                yield this.generateSinceMonitor(since);
            }
            default -> this.illegalFormula(f);
        };
    }

    private TemporalMonitor<T, R> illegalFormula(Formula f) {
        throw new IllegalArgumentException("Unsupported formula: " + f);
    }

    private TemporalMonitor<T, R> generateAtomicMonitor(AtomicFormula f) {
        Function<Parameters, Function<Object, R>> atomicFunc = this.atoms.get(f.getAtomicId());
        if (atomicFunc == null) {
            throw new IllegalArgumentException("Unknown atomic ID " + f.getAtomicId());
        }
        Function<T, R> atomic = atomicFunc.apply(null);
        return TemporalMonitor.atomicMonitor(atomic);
    }

    private TemporalMonitor<T, R> generateAndMonitor(AndFormula f) {
        TemporalMonitor<T, R> leftMonitor = this.monitor(f.getFirstArgument());
        TemporalMonitor<T, R> rightMonitor = this.monitor(f.getSecondArgument());
        return TemporalMonitor.andMonitor(leftMonitor, this.module, rightMonitor);
    }

    private TemporalMonitor<T, R> generateOrMonitor(OrFormula f) {
        TemporalMonitor<T, R> leftMonitor = this.monitor(f.getFirstArgument());
        TemporalMonitor<T, R> rightMonitor = this.monitor(f.getSecondArgument());
        return TemporalMonitor.orMonitor(leftMonitor, this.module, rightMonitor);
    }

    private TemporalMonitor<T, R> generateNegationMonitor(NegationFormula f) {
        TemporalMonitor<T, R> argumentMonitoring = this.monitor(f.getArgument());
        return TemporalMonitor.notMonitor(argumentMonitoring, this.module);
    }

    private TemporalMonitor<T, R> generateEventuallyMonitor(EventuallyFormula f) {
        TemporalMonitor<T, R> argMonitor = this.monitor(f.getArgument());
        if (f.isUnbounded()) {
            return TemporalMonitor.eventuallyMonitor(argMonitor, this.module);
        }
        Interval interval = f.getInterval();
        return TemporalMonitor.eventuallyMonitor(argMonitor, this.module, interval);
    }

    private TemporalMonitor<T, R> generateGloballyMonitor(GloballyFormula f) {
        TemporalMonitor<T, R> argMonitor = this.monitor(f.getArgument());
        if (f.isUnbounded()) {
            return TemporalMonitor.globallyMonitor(argMonitor, this.module);
        }
        Interval interval = f.getInterval();
        return TemporalMonitor.globallyMonitor(argMonitor, this.module, interval);
    }

    private TemporalMonitor<T, R> generateOnceMonitor(OnceFormula f) {
        TemporalMonitor<T, R> argMonitor = this.monitor(f.getArgument());
        if (f.isUnbounded()) {
            return TemporalMonitor.onceMonitor(argMonitor, this.module);
        }
        Interval interval = f.getInterval();
        return TemporalMonitor.onceMonitor(argMonitor, this.module, interval);
    }

    private TemporalMonitor<T, R> generateHistoricallyMonitor(HistoricallyFormula f) {
        TemporalMonitor<T, R> argMonitor = this.monitor(f.getArgument());
        if (f.isUnbounded()) {
            return TemporalMonitor.historicallyMonitor(argMonitor, this.module);
        }
        Interval interval = f.getInterval();
        return TemporalMonitor.historicallyMonitor(argMonitor, this.module, interval);
    }

    private TemporalMonitor<T, R> generateUntilMonitor(UntilFormula f) {
        TemporalMonitor<T, R> leftMonitor = this.monitor(f.getFirstArgument());
        TemporalMonitor<T, R> rightMonitor = this.monitor(f.getSecondArgument());
        if (f.isUnbounded()) {
            return TemporalMonitor.untilMonitor(leftMonitor, rightMonitor, this.module);
        }
        return TemporalMonitor.untilMonitor(leftMonitor, f.getInterval(), rightMonitor, this.module);
    }

    private TemporalMonitor<T, R> generateSinceMonitor(SinceFormula f) {
        TemporalMonitor<T, R> leftMonitor = this.monitor(f.getFirstArgument());
        TemporalMonitor<T, R> rightMonitor = this.monitor(f.getSecondArgument());
        if (f.isUnbounded()) {
            return TemporalMonitor.sinceMonitor(leftMonitor, rightMonitor, this.module);
        }
        return TemporalMonitor.sinceMonitor(leftMonitor, f.getInterval(), rightMonitor, this.module);
    }
}

