/*
 * Decompiled with CFR 0.152.
 */
package eu.quanticol.moonlight.io;

import eu.quanticol.moonlight.io.UnsupportedFileTypeException;
import eu.quanticol.moonlight.io.parsing.FileType;
import eu.quanticol.moonlight.io.parsing.ParsingStrategy;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;

public class DataReader<T> {
    private final FileType type;
    private final InputStream input;
    private final ParsingStrategy<T> strategy;

    public DataReader(InputStream input, FileType type, ParsingStrategy<T> strategy) {
        this.input = input;
        this.type = type;
        this.strategy = strategy;
    }

    public T read() {
        try {
            BufferedReader fileReader = new BufferedReader(new InputStreamReader(this.input));
            fileReader = this.readHeader(fileReader);
            this.readLines(fileReader);
            fileReader.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return this.strategy.result();
    }

    private BufferedReader readHeader(BufferedReader fileReader) throws IOException {
        this.input.mark(0);
        String header = fileReader.readLine();
        this.strategy.initialize(this.splitLine(header));
        if (FileType.TEXT == this.type) {
            this.input.reset();
            fileReader = new BufferedReader(new InputStreamReader(this.input));
        }
        return fileReader;
    }

    private void readLines(BufferedReader fileReader) throws IOException {
        String row;
        while (null != (row = fileReader.readLine())) {
            this.strategy.process(this.splitLine(row));
        }
    }

    private String[] splitLine(String target) {
        String[] data;
        if (FileType.CSV == this.type) {
            data = target.split(",");
        } else if (FileType.TEXT == this.type) {
            data = target.split(" ");
        } else {
            throw new UnsupportedFileTypeException("The file format doesn't comply with the allowed ones.");
        }
        return data;
    }
}

