/*
 * Decompiled with CFR 0.152.
 */
package eu.quanticol.moonlight.io;

import eu.quanticol.moonlight.core.base.MoonLightRecord;
import eu.quanticol.moonlight.offline.signal.RecordHandler;
import eu.quanticol.moonlight.offline.signal.Signal;
import eu.quanticol.moonlight.offline.signal.SpatialTemporalSignal;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class AbstractFileByRowReader {
    protected List<Row> getRows(File input) throws IOException {
        return this.collectDataRows(Files.lines(input.toPath()));
    }

    protected List<Row> getRows(String input) {
        return this.collectDataRows(Stream.of(input.split("\n")));
    }

    protected List<Row> collectDataRows(Stream<String> lines) {
        List data = lines.map(x$0 -> new Row((String)x$0)).collect(Collectors.toList());
        int line = 1;
        for (Row r2 : data) {
            r2.setLineNumber(line++);
        }
        return data.stream().filter(r -> !r.isEmpty()).collect(Collectors.toList());
    }

    public class Row {
        int index;
        String row;
        String[] elements;

        public Row(String row) {
            this.row = row;
            this.elements = new String[]{row};
        }

        public void split(String regex) {
            if (this.row.trim().isEmpty()) {
                this.elements = null;
            } else {
                this.elements = this.row.split(regex);
                for (int i = 0; i < this.elements.length; ++i) {
                    this.elements[i] = this.elements[i].trim();
                }
            }
        }

        public void setLineNumber(int index) {
            this.index = index;
        }

        public boolean isEmpty() {
            return this.elements == null;
        }

        public boolean isDouble(int idx) {
            if (!this.isEmpty() && 0 <= idx && idx < this.elements.length) {
                try {
                    Double.parseDouble(this.get(idx));
                    return true;
                }
                catch (NumberFormatException e) {
                    return false;
                }
            }
            return false;
        }

        public boolean isInteger(int idx) {
            if (!this.isEmpty() && 0 <= idx && idx < this.elements.length) {
                try {
                    Integer.parseInt(this.get(idx));
                    return true;
                }
                catch (NumberFormatException e) {
                    return false;
                }
            }
            return false;
        }

        public boolean checkRecord(RecordHandler handler) {
            if (this.elements != null) {
                return this.checkRecord(handler, 1, this.elements.length);
            }
            return true;
        }

        public boolean checkRecord(RecordHandler handler, int from, int to) {
            return this.elements == null || handler.checkValuesFromStrings(this.elements, from, to);
        }

        public void addValueToSignal(RecordHandler handler, Signal<MoonLightRecord> s) {
            if (this.elements != null) {
                double t = Double.parseDouble(this.elements[0]);
                MoonLightRecord r = handler.fromStringArray(this.elements, 1, this.elements.length);
                s.add(t, r);
            }
        }

        public void addValueToSpatioTemporalSignal(int size, RecordHandler handler, SpatialTemporalSignal<MoonLightRecord> s) {
            if (this.elements != null) {
                double t = Double.parseDouble(this.elements[0]);
                MoonLightRecord[] data = new MoonLightRecord[size];
                for (int i = 0; i < size; ++i) {
                    int first = 1 + i * handler.size();
                    data[i] = handler.fromStringArray(this.elements, first, first + handler.size());
                }
                s.add(t, (MoonLightRecord[])data);
            }
        }

        public String get(int i) {
            if (this.elements != null) {
                return this.elements[i].trim();
            }
            throw new IllegalStateException();
        }

        public String getRow() {
            return this.row;
        }

        public int getLine() {
            return this.index;
        }
    }
}

