/*
 * Decompiled with CFR 0.152.
 */
package eu.quanticol.moonlight.core.space;

import eu.quanticol.moonlight.core.base.MoonLightRecord;
import eu.quanticol.moonlight.core.base.Pair;
import eu.quanticol.moonlight.offline.signal.RecordHandler;
import eu.quanticol.moonlight.space.GraphModel;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public interface SpatialModel<E> {
    public E get(int var1, int var2);

    public int size();

    public List<Pair<Integer, E>> next(int var1);

    public List<Pair<Integer, E>> previous(int var1);

    public static SpatialModel<MoonLightRecord> buildSpatialModelFromAdjacencyList(int locations, RecordHandler edgeRecordHandler, String[][] data) {
        GraphModel<MoonLightRecord> toReturn = new GraphModel<MoonLightRecord>(locations);
        for (String[] row : data) {
            int src = Integer.parseInt(row[0]);
            int trg = Integer.parseInt(row[1]);
            toReturn.add(src, edgeRecordHandler.fromStringArray(row, 2, row.length), trg);
        }
        return toReturn;
    }

    public static SpatialModel<MoonLightRecord> buildSpatialModelFromAdjacencyList(int locations, RecordHandler edgeRecordHandler, double[][] data) {
        GraphModel<MoonLightRecord> toReturn = new GraphModel<MoonLightRecord>(locations);
        for (double[] row : data) {
            int src = (int)row[0];
            int trg = (int)row[1];
            toReturn.add(src, edgeRecordHandler.fromDoubleArray(row, 2, row.length), trg);
        }
        return toReturn;
    }

    public static SpatialModel<MoonLightRecord> buildSpatialModelFromAdjacencyMatrix(int locations, RecordHandler edgeRecordHandler, String[][][] data) {
        GraphModel<MoonLightRecord> toReturn = new GraphModel<MoonLightRecord>(locations);
        for (int i = 0; i < data.length; ++i) {
            for (int j = 0; j < data[i].length; ++j) {
                if (i == j || !Boolean.TRUE.equals(SpatialModel.isFull(data[i][j]))) continue;
                toReturn.add(i, edgeRecordHandler.fromStringArray(data[i][j]), j);
            }
        }
        return toReturn;
    }

    public static SpatialModel<MoonLightRecord> buildSpatialModelFromAdjacencyMatrix(int locations, RecordHandler edgeRecordHandler, double[][][] objects) {
        GraphModel<MoonLightRecord> toReturn = new GraphModel<MoonLightRecord>(locations);
        for (int i = 0; i < objects.length; ++i) {
            for (int j = 0; j < objects[i].length; ++j) {
                if (i == j || !Boolean.TRUE.equals(SpatialModel.isFull(objects[i][j]))) continue;
                toReturn.add(i, edgeRecordHandler.fromDoubleArray(objects[i][j]), j);
            }
        }
        return toReturn;
    }

    public static Boolean isFull(String[] array) {
        return !Arrays.stream(array).allMatch(Objects::isNull);
    }

    public static Boolean isFull(double[] array) {
        return !Arrays.stream(array).allMatch(Objects::isNull);
    }
}

