import { CfnVirtualNode } from './appmesh.generated';
import { HealthCheck } from './health-checks';
import { ListenerTlsOptions } from './listener-tls-options';
import { GrpcConnectionPool, GrpcTimeout, Http2ConnectionPool, HttpConnectionPool, HttpTimeout, OutlierDetection, TcpConnectionPool, TcpTimeout } from './shared-interfaces';
import { Construct } from '@aws-cdk/core';
/**
 * (experimental) Properties for a VirtualNode listener.
 *
 * @experimental
 */
export interface VirtualNodeListenerConfig {
    /**
     * (experimental) Single listener config for a VirtualNode.
     *
     * @experimental
     */
    readonly listener: CfnVirtualNode.ListenerProperty;
}
/**
 * Represents the properties needed to define a Listeners for a VirtualNode
 */
interface VirtualNodeListenerCommonOptions {
    /**
     * (experimental) Port to listen for connections on.
     *
     * @default - 8080
     * @experimental
     */
    readonly port?: number;
    /**
     * (experimental) The health check information for the listener.
     *
     * @default - no healthcheck
     * @experimental
     */
    readonly healthCheck?: HealthCheck;
    /**
     * (experimental) Represents the configuration for enabling TLS on a listener.
     *
     * @default - none
     * @experimental
     */
    readonly tls?: ListenerTlsOptions;
    /**
     * (experimental) Represents the configuration for enabling outlier detection.
     *
     * @default - none
     * @experimental
     */
    readonly outlierDetection?: OutlierDetection;
}
interface CommonHttpVirtualNodeListenerOptions extends VirtualNodeListenerCommonOptions {
    /**
     * (experimental) Timeout for HTTP protocol.
     *
     * @default - None
     * @experimental
     */
    readonly timeout?: HttpTimeout;
}
/**
 * (experimental) Represent the HTTP Node Listener prorperty.
 *
 * @experimental
 */
export interface HttpVirtualNodeListenerOptions extends CommonHttpVirtualNodeListenerOptions {
    /**
     * (experimental) Connection pool for http listeners.
     *
     * @default - None
     * @experimental
     */
    readonly connectionPool?: HttpConnectionPool;
}
/**
 * (experimental) Represent the HTTP2 Node Listener prorperty.
 *
 * @experimental
 */
export interface Http2VirtualNodeListenerOptions extends CommonHttpVirtualNodeListenerOptions {
    /**
     * (experimental) Connection pool for http2 listeners.
     *
     * @default - None
     * @experimental
     */
    readonly connectionPool?: Http2ConnectionPool;
}
/**
 * (experimental) Represent the GRPC Node Listener prorperty.
 *
 * @experimental
 */
export interface GrpcVirtualNodeListenerOptions extends VirtualNodeListenerCommonOptions {
    /**
     * (experimental) Timeout for GRPC protocol.
     *
     * @default - None
     * @experimental
     */
    readonly timeout?: GrpcTimeout;
    /**
     * (experimental) Connection pool for http listeners.
     *
     * @default - None
     * @experimental
     */
    readonly connectionPool?: GrpcConnectionPool;
}
/**
 * (experimental) Represent the TCP Node Listener prorperty.
 *
 * @experimental
 */
export interface TcpVirtualNodeListenerOptions extends VirtualNodeListenerCommonOptions {
    /**
     * (experimental) Timeout for TCP protocol.
     *
     * @default - None
     * @experimental
     */
    readonly timeout?: TcpTimeout;
    /**
     * (experimental) Connection pool for http listeners.
     *
     * @default - None
     * @experimental
     */
    readonly connectionPool?: TcpConnectionPool;
}
/**
 * (experimental) Defines listener for a VirtualNode.
 *
 * @experimental
 */
export declare abstract class VirtualNodeListener {
    /**
     * (experimental) Returns an HTTP Listener for a VirtualNode.
     *
     * @experimental
     */
    static http(props?: HttpVirtualNodeListenerOptions): VirtualNodeListener;
    /**
     * (experimental) Returns an HTTP2 Listener for a VirtualNode.
     *
     * @experimental
     */
    static http2(props?: Http2VirtualNodeListenerOptions): VirtualNodeListener;
    /**
     * (experimental) Returns an GRPC Listener for a VirtualNode.
     *
     * @experimental
     */
    static grpc(props?: GrpcVirtualNodeListenerOptions): VirtualNodeListener;
    /**
     * (experimental) Returns an TCP Listener for a VirtualNode.
     *
     * @experimental
     */
    static tcp(props?: TcpVirtualNodeListenerOptions): VirtualNodeListener;
    /**
     * (experimental) Binds the current object when adding Listener to a VirtualNode.
     *
     * @experimental
     */
    abstract bind(scope: Construct): VirtualNodeListenerConfig;
}
export {};
