import { CfnVirtualGateway } from './appmesh.generated';
import { HealthCheck } from './health-checks';
import { ListenerTlsOptions } from './listener-tls-options';
import { GrpcConnectionPool, Http2ConnectionPool, HttpConnectionPool } from './shared-interfaces';
import { Construct } from '@aws-cdk/core';
/**
 * Represents the properties needed to define a Listeners for a VirtualGateway
 */
interface VirtualGatewayListenerCommonOptions {
    /**
     * (experimental) Port to listen for connections on.
     *
     * @default - 8080
     * @experimental
     */
    readonly port?: number;
    /**
     * (experimental) The health check information for the listener.
     *
     * @default - no healthcheck
     * @experimental
     */
    readonly healthCheck?: HealthCheck;
    /**
     * (experimental) Represents the configuration for enabling TLS on a listener.
     *
     * @default - none
     * @experimental
     */
    readonly tls?: ListenerTlsOptions;
}
/**
 * (experimental) Represents the properties needed to define HTTP Listeners for a VirtualGateway.
 *
 * @experimental
 */
export interface HttpGatewayListenerOptions extends VirtualGatewayListenerCommonOptions {
    /**
     * (experimental) Connection pool for http listeners.
     *
     * @default - None
     * @experimental
     */
    readonly connectionPool?: HttpConnectionPool;
}
/**
 * (experimental) Represents the properties needed to define HTTP2 Listeners for a VirtualGateway.
 *
 * @experimental
 */
export interface Http2GatewayListenerOptions extends VirtualGatewayListenerCommonOptions {
    /**
     * (experimental) Connection pool for http listeners.
     *
     * @default - None
     * @experimental
     */
    readonly connectionPool?: Http2ConnectionPool;
}
/**
 * (experimental) Represents the properties needed to define GRPC Listeners for a VirtualGateway.
 *
 * @experimental
 */
export interface GrpcGatewayListenerOptions extends VirtualGatewayListenerCommonOptions {
    /**
     * (experimental) Connection pool for http listeners.
     *
     * @default - None
     * @experimental
     */
    readonly connectionPool?: GrpcConnectionPool;
}
/**
 * (experimental) Properties for a VirtualGateway listener.
 *
 * @experimental
 */
export interface VirtualGatewayListenerConfig {
    /**
     * (experimental) Single listener config for a VirtualGateway.
     *
     * @experimental
     */
    readonly listener: CfnVirtualGateway.VirtualGatewayListenerProperty;
}
/**
 * (experimental) Represents the properties needed to define listeners for a VirtualGateway.
 *
 * @experimental
 */
export declare abstract class VirtualGatewayListener {
    /**
     * (experimental) Returns an HTTP Listener for a VirtualGateway.
     *
     * @experimental
     */
    static http(options?: HttpGatewayListenerOptions): VirtualGatewayListener;
    /**
     * (experimental) Returns an HTTP2 Listener for a VirtualGateway.
     *
     * @experimental
     */
    static http2(options?: Http2GatewayListenerOptions): VirtualGatewayListener;
    /**
     * (experimental) Returns a GRPC Listener for a VirtualGateway.
     *
     * @experimental
     */
    static grpc(options?: GrpcGatewayListenerOptions): VirtualGatewayListener;
    /**
     * (experimental) Called when the GatewayListener type is initialized.
     *
     * Can be used to enforce
     * mutual exclusivity
     *
     * @experimental
     */
    abstract bind(scope: Construct): VirtualGatewayListenerConfig;
}
export {};
