import * as acmpca from '@aws-cdk/aws-acmpca';
import { CfnVirtualNode } from './appmesh.generated';
import { Construct } from '@aws-cdk/core';
/**
 * Represents the properties needed to define TLS Validation context
 */
interface TlsValidationCommon {
    /**
     * (experimental) Represents the subject alternative names (SANs) secured by the certificate.
     *
     * SANs must be in the FQDN or URI format.
     *
     * @default - If you don't specify SANs on the terminating mesh endpoint,
     * the Envoy proxy for that node doesn't verify the SAN on a peer client certificate.
     * If you don't specify SANs on the originating mesh endpoint,
     * the SAN on the certificate provided by the terminating endpoint must match the mesh endpoint service discovery configuration.
     * @experimental
     */
    readonly subjectAlternativeNames?: SubjectAlternativeNames;
}
/**
 * (experimental) Represents the properties needed to define TLS Validation context.
 *
 * @experimental
 */
export interface TlsValidation extends TlsValidationCommon {
    /**
     * (experimental) Reference to where to retrieve the trust chain.
     *
     * @experimental
     */
    readonly trust: TlsValidationTrust;
}
/**
 * (experimental) Represents the properties needed to define TLS Validation context that is supported for mutual TLS authentication.
 *
 * @experimental
 */
export interface MutualTlsValidation extends TlsValidationCommon {
    /**
     * (experimental) Reference to where to retrieve the trust chain.
     *
     * @experimental
     */
    readonly trust: MutualTlsValidationTrust;
}
/**
 * (experimental) All Properties for TLS Validation Trusts for both Client Policy and Listener.
 *
 * @experimental
 */
export interface TlsValidationTrustConfig {
    /**
     * (experimental) VirtualNode CFN configuration for client policy's TLS Validation Trust.
     *
     * @experimental
     */
    readonly tlsValidationTrust: CfnVirtualNode.TlsValidationContextTrustProperty;
}
/**
 * (experimental) Defines the TLS Validation Context Trust.
 *
 * @experimental
 */
export declare abstract class TlsValidationTrust {
    /**
     * (experimental) Tells envoy where to fetch the validation context from.
     *
     * @experimental
     */
    static file(certificateChain: string): MutualTlsValidationTrust;
    /**
     * (experimental) TLS Validation Context Trust for ACM Private Certificate Authority (CA).
     *
     * @experimental
     */
    static acm(certificateAuthorities: acmpca.ICertificateAuthority[]): TlsValidationTrust;
    /**
     * (experimental) TLS Validation Context Trust for Envoy' service discovery service.
     *
     * @experimental
     */
    static sds(secretName: string): MutualTlsValidationTrust;
    /**
     * (experimental) Returns Trust context based on trust type.
     *
     * @experimental
     */
    abstract bind(scope: Construct): TlsValidationTrustConfig;
}
/**
 * (experimental) Represents a TLS Validation Context Trust that is supported for mutual TLS authentication.
 *
 * @experimental
 */
export declare abstract class MutualTlsValidationTrust extends TlsValidationTrust {
    /**
     * @experimental
     */
    protected readonly differentiator = false;
}
/**
 * (experimental) All Properties for Subject Alternative Names Matcher for both Client Policy and Listener.
 *
 * @experimental
 */
export interface SubjectAlternativeNamesMatcherConfig {
    /**
     * (experimental) VirtualNode CFN configuration for subject alternative names secured by the certificate.
     *
     * @experimental
     */
    readonly subjectAlternativeNamesMatch: CfnVirtualNode.SubjectAlternativeNameMatchersProperty;
}
/**
 * (experimental) Used to generate Subject Alternative Names Matchers.
 *
 * @experimental
 */
export declare abstract class SubjectAlternativeNames {
    /**
     * (experimental) The values of the SAN must match the specified values exactly.
     *
     * @param names The exact values to test against.
     * @experimental
     */
    static matchingExactly(...names: string[]): SubjectAlternativeNames;
    /**
     * (experimental) Returns Subject Alternative Names Matcher based on method type.
     *
     * @experimental
     */
    abstract bind(scope: Construct): SubjectAlternativeNamesMatcherConfig;
}
export {};
