"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.RouteSpec = exports.GrpcRetryEvent = exports.TcpRetryEvent = exports.HttpRetryEvent = exports.HttpHeaderMatch = exports.HttpRouteProtocol = exports.HttpRouteMatchMethod = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const shared_interfaces_1 = require("./shared-interfaces");
/**
 * (experimental) Supported values for matching routes based on the HTTP request method.
 *
 * @experimental
 */
var HttpRouteMatchMethod;
(function (HttpRouteMatchMethod) {
    HttpRouteMatchMethod["GET"] = "GET";
    HttpRouteMatchMethod["HEAD"] = "HEAD";
    HttpRouteMatchMethod["POST"] = "POST";
    HttpRouteMatchMethod["PUT"] = "PUT";
    HttpRouteMatchMethod["DELETE"] = "DELETE";
    HttpRouteMatchMethod["CONNECT"] = "CONNECT";
    HttpRouteMatchMethod["OPTIONS"] = "OPTIONS";
    HttpRouteMatchMethod["TRACE"] = "TRACE";
    HttpRouteMatchMethod["PATCH"] = "PATCH";
})(HttpRouteMatchMethod = exports.HttpRouteMatchMethod || (exports.HttpRouteMatchMethod = {}));
/**
 * (experimental) Supported :scheme options for HTTP2.
 *
 * @experimental
 */
var HttpRouteProtocol;
(function (HttpRouteProtocol) {
    HttpRouteProtocol["HTTP"] = "http";
    HttpRouteProtocol["HTTPS"] = "https";
})(HttpRouteProtocol = exports.HttpRouteProtocol || (exports.HttpRouteProtocol = {}));
/**
 * (experimental) Used to generate header matching methods.
 *
 * @experimental
 */
class HttpHeaderMatch {
    /**
     * (experimental) The value of the header with the given name in the request must match the specified value exactly.
     *
     * @param headerName the name of the HTTP header to match against.
     * @param headerValue The exact value to test against.
     * @experimental
     */
    static valueIs(headerName, headerValue) {
        return new HeaderMatchImpl(headerName, false, { exact: headerValue });
    }
    /**
     * (experimental) The value of the header with the given name in the request must not match the specified value exactly.
     *
     * @param headerName the name of the HTTP header to match against.
     * @param headerValue The exact value to test against.
     * @experimental
     */
    static valueIsNot(headerName, headerValue) {
        return new HeaderMatchImpl(headerName, true, { exact: headerValue });
    }
    /**
     * (experimental) The value of the header with the given name in the request must start with the specified characters.
     *
     * @param headerName the name of the HTTP header to match against.
     * @param prefix The prefix to test against.
     * @experimental
     */
    static valueStartsWith(headerName, prefix) {
        return new HeaderMatchImpl(headerName, false, { prefix });
    }
    /**
     * (experimental) The value of the header with the given name in the request must not start with the specified characters.
     *
     * @param headerName the name of the HTTP header to match against.
     * @param prefix The prefix to test against.
     * @experimental
     */
    static valueDoesNotStartWith(headerName, prefix) {
        return new HeaderMatchImpl(headerName, true, { prefix });
    }
    /**
     * (experimental) The value of the header with the given name in the request must end with the specified characters.
     *
     * @param headerName the name of the HTTP header to match against.
     * @param suffix The suffix to test against.
     * @experimental
     */
    static valueEndsWith(headerName, suffix) {
        return new HeaderMatchImpl(headerName, false, { suffix });
    }
    /**
     * (experimental) The value of the header with the given name in the request must not end with the specified characters.
     *
     * @param headerName the name of the HTTP header to match against.
     * @param suffix The suffix to test against.
     * @experimental
     */
    static valueDoesNotEndWith(headerName, suffix) {
        return new HeaderMatchImpl(headerName, true, { suffix });
    }
    /**
     * (experimental) The value of the header with the given name in the request must include the specified characters.
     *
     * @param headerName the name of the HTTP header to match against.
     * @param regex The regex to test against.
     * @experimental
     */
    static valueMatchesRegex(headerName, regex) {
        return new HeaderMatchImpl(headerName, false, { regex });
    }
    /**
     * (experimental) The value of the header with the given name in the request must not include the specified characters.
     *
     * @param headerName the name of the HTTP header to match against.
     * @param regex The regex to test against.
     * @experimental
     */
    static valueDoesNotMatchRegex(headerName, regex) {
        return new HeaderMatchImpl(headerName, true, { regex });
    }
    /**
     * (experimental) The value of the header with the given name in the request must be in a range of values.
     *
     * @param headerName the name of the HTTP header to match against.
     * @param start Match on values starting at and including this value.
     * @param end Match on values up to but not including this value.
     * @experimental
     */
    static valuesIsInRange(headerName, start, end) {
        return new HeaderMatchImpl(headerName, false, {
            range: {
                start,
                end,
            },
        });
    }
    /**
     * (experimental) The value of the header with the given name in the request must not be in a range of values.
     *
     * @param headerName the name of the HTTP header to match against.
     * @param start Match on values starting at and including this value.
     * @param end Match on values up to but not including this value.
     * @experimental
     */
    static valuesIsNotInRange(headerName, start, end) {
        return new HeaderMatchImpl(headerName, true, {
            range: {
                start,
                end,
            },
        });
    }
}
exports.HttpHeaderMatch = HttpHeaderMatch;
_a = JSII_RTTI_SYMBOL_1;
HttpHeaderMatch[_a] = { fqn: "@aws-cdk/aws-appmesh.HttpHeaderMatch", version: "1.110.1" };
class HeaderMatchImpl extends HttpHeaderMatch {
    constructor(headerName, invert, matchProperty) {
        super();
        this.headerName = headerName;
        this.invert = invert;
        this.matchProperty = matchProperty;
    }
    bind(_scope) {
        return {
            httpRouteHeader: {
                name: this.headerName,
                invert: this.invert,
                match: this.matchProperty,
            },
        };
    }
}
/**
 * (experimental) HTTP events on which to retry.
 *
 * @experimental
 */
var HttpRetryEvent;
(function (HttpRetryEvent) {
    HttpRetryEvent["SERVER_ERROR"] = "server-error";
    HttpRetryEvent["GATEWAY_ERROR"] = "gateway-error";
    HttpRetryEvent["CLIENT_ERROR"] = "client-error";
    HttpRetryEvent["STREAM_ERROR"] = "stream-error";
})(HttpRetryEvent = exports.HttpRetryEvent || (exports.HttpRetryEvent = {}));
/**
 * TCP events on which you may retry
 */
var TcpRetryEvent;
(function (TcpRetryEvent) {
    TcpRetryEvent["CONNECTION_ERROR"] = "connection-error";
})(TcpRetryEvent = exports.TcpRetryEvent || (exports.TcpRetryEvent = {}));
/**
 * (experimental) gRPC events.
 *
 * @experimental
 */
var GrpcRetryEvent;
(function (GrpcRetryEvent) {
    GrpcRetryEvent["CANCELLED"] = "cancelled";
    GrpcRetryEvent["DEADLINE_EXCEEDED"] = "deadline-exceeded";
    GrpcRetryEvent["INTERNAL_ERROR"] = "internal";
    GrpcRetryEvent["RESOURCE_EXHAUSTED"] = "resource-exhausted";
    GrpcRetryEvent["UNAVAILABLE"] = "unavailable";
})(GrpcRetryEvent = exports.GrpcRetryEvent || (exports.GrpcRetryEvent = {}));
/**
 * (experimental) Used to generate specs with different protocols for a RouteSpec.
 *
 * @experimental
 */
class RouteSpec {
    /**
     * (experimental) Creates an HTTP Based RouteSpec.
     *
     * @experimental
     */
    static http(options) {
        return new HttpRouteSpec(options, shared_interfaces_1.Protocol.HTTP);
    }
    /**
     * (experimental) Creates an HTTP2 Based RouteSpec.
     *
     * @experimental
     */
    static http2(options) {
        return new HttpRouteSpec(options, shared_interfaces_1.Protocol.HTTP2);
    }
    /**
     * (experimental) Creates a TCP Based RouteSpec.
     *
     * @experimental
     */
    static tcp(options) {
        return new TcpRouteSpec(options);
    }
    /**
     * (experimental) Creates a GRPC Based RouteSpec.
     *
     * @experimental
     */
    static grpc(options) {
        return new GrpcRouteSpec(options);
    }
}
exports.RouteSpec = RouteSpec;
_b = JSII_RTTI_SYMBOL_1;
RouteSpec[_b] = { fqn: "@aws-cdk/aws-appmesh.RouteSpec", version: "1.110.1" };
class HttpRouteSpec extends RouteSpec {
    constructor(props, protocol) {
        var _c, _d;
        super();
        this.protocol = protocol;
        this.match = props.match;
        this.weightedTargets = props.weightedTargets;
        this.timeout = props.timeout;
        this.priority = props.priority;
        if (props.retryPolicy) {
            const httpRetryEvents = (_c = props.retryPolicy.httpRetryEvents) !== null && _c !== void 0 ? _c : [];
            const tcpRetryEvents = (_d = props.retryPolicy.tcpRetryEvents) !== null && _d !== void 0 ? _d : [];
            if (httpRetryEvents.length + tcpRetryEvents.length === 0) {
                throw new Error('You must specify one value for at least one of `httpRetryEvents` or `tcpRetryEvents`');
            }
            this.retryPolicy = {
                ...props.retryPolicy,
                httpRetryEvents: httpRetryEvents.length > 0 ? httpRetryEvents : undefined,
                tcpRetryEvents: tcpRetryEvents.length > 0 ? tcpRetryEvents : undefined,
            };
        }
    }
    bind(scope) {
        var _c, _d, _e, _f;
        const prefixPath = this.match ? this.match.prefixPath : '/';
        if (prefixPath[0] != '/') {
            throw new Error(`Prefix Path must start with \'/\', got: ${prefixPath}`);
        }
        const httpConfig = {
            action: {
                weightedTargets: renderWeightedTargets(this.weightedTargets),
            },
            match: {
                prefix: prefixPath,
                headers: (_d = (_c = this.match) === null || _c === void 0 ? void 0 : _c.headers) === null || _d === void 0 ? void 0 : _d.map(header => header.bind(scope).httpRouteHeader),
                method: (_e = this.match) === null || _e === void 0 ? void 0 : _e.method,
                scheme: (_f = this.match) === null || _f === void 0 ? void 0 : _f.protocol,
            },
            timeout: renderTimeout(this.timeout),
            retryPolicy: this.retryPolicy ? renderHttpRetryPolicy(this.retryPolicy) : undefined,
        };
        return {
            priority: this.priority,
            httpRouteSpec: this.protocol === shared_interfaces_1.Protocol.HTTP ? httpConfig : undefined,
            http2RouteSpec: this.protocol === shared_interfaces_1.Protocol.HTTP2 ? httpConfig : undefined,
        };
    }
}
class TcpRouteSpec extends RouteSpec {
    constructor(props) {
        super();
        this.weightedTargets = props.weightedTargets;
        this.timeout = props.timeout;
        this.priority = props.priority;
    }
    bind(_scope) {
        return {
            priority: this.priority,
            tcpRouteSpec: {
                action: {
                    weightedTargets: renderWeightedTargets(this.weightedTargets),
                },
                timeout: renderTimeout(this.timeout),
            },
        };
    }
}
class GrpcRouteSpec extends RouteSpec {
    constructor(props) {
        var _c, _d, _e;
        super();
        this.weightedTargets = props.weightedTargets;
        this.match = props.match;
        this.timeout = props.timeout;
        this.priority = props.priority;
        if (props.retryPolicy) {
            const grpcRetryEvents = (_c = props.retryPolicy.grpcRetryEvents) !== null && _c !== void 0 ? _c : [];
            const httpRetryEvents = (_d = props.retryPolicy.httpRetryEvents) !== null && _d !== void 0 ? _d : [];
            const tcpRetryEvents = (_e = props.retryPolicy.tcpRetryEvents) !== null && _e !== void 0 ? _e : [];
            if (grpcRetryEvents.length + httpRetryEvents.length + tcpRetryEvents.length === 0) {
                throw new Error('You must specify one value for at least one of `grpcRetryEvents`, `httpRetryEvents` or `tcpRetryEvents`');
            }
            this.retryPolicy = {
                ...props.retryPolicy,
                grpcRetryEvents: grpcRetryEvents.length > 0 ? grpcRetryEvents : undefined,
                httpRetryEvents: httpRetryEvents.length > 0 ? httpRetryEvents : undefined,
                tcpRetryEvents: tcpRetryEvents.length > 0 ? tcpRetryEvents : undefined,
            };
        }
    }
    bind(_scope) {
        return {
            priority: this.priority,
            grpcRouteSpec: {
                action: {
                    weightedTargets: renderWeightedTargets(this.weightedTargets),
                },
                match: {
                    serviceName: this.match.serviceName,
                },
                timeout: renderTimeout(this.timeout),
                retryPolicy: this.retryPolicy ? renderGrpcRetryPolicy(this.retryPolicy) : undefined,
            },
        };
    }
}
/**
* Utility method to add weighted route targets to an existing route
*/
function renderWeightedTargets(weightedTargets) {
    const renderedTargets = [];
    for (const t of weightedTargets) {
        renderedTargets.push({
            virtualNode: t.virtualNode.virtualNodeName,
            weight: t.weight || 1,
        });
    }
    return renderedTargets;
}
/**
 * Utility method to construct a route timeout object
 */
function renderTimeout(timeout) {
    return timeout
        ? {
            idle: (timeout === null || timeout === void 0 ? void 0 : timeout.idle) !== undefined
                ? {
                    unit: 'ms',
                    value: timeout === null || timeout === void 0 ? void 0 : timeout.idle.toMilliseconds(),
                }
                : undefined,
            perRequest: (timeout === null || timeout === void 0 ? void 0 : timeout.perRequest) !== undefined
                ? {
                    unit: 'ms',
                    value: timeout === null || timeout === void 0 ? void 0 : timeout.perRequest.toMilliseconds(),
                }
                : undefined,
        }
        : undefined;
}
function renderHttpRetryPolicy(retryPolicy) {
    return {
        maxRetries: retryPolicy.retryAttempts,
        perRetryTimeout: {
            unit: 'ms',
            value: retryPolicy.retryTimeout.toMilliseconds(),
        },
        httpRetryEvents: retryPolicy.httpRetryEvents,
        tcpRetryEvents: retryPolicy.tcpRetryEvents,
    };
}
function renderGrpcRetryPolicy(retryPolicy) {
    return {
        ...renderHttpRetryPolicy(retryPolicy),
        grpcRetryEvents: retryPolicy.grpcRetryEvents,
    };
}
//# sourceMappingURL=data:application/json;base64,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