#!/usr/bin/env python
# setup.py generated by flit for tools that don't yet use PEP 517

from distutils.core import setup

packages = \
['hydromt', 'hydromt.cli', 'hydromt.models', 'hydromt.workflows']

package_data = \
{'': ['*']}

install_requires = \
['affine',
 'bottleneck',
 'click',
 'dask',
 'geopandas>=0.10',
 'entrypoints',
 'gdal>=3.1',
 'numba',
 'numpy',
 'netcdf4',
 'pandas',
 'pyflwdir>=0.5.3',
 'pygeos',
 'openpyxl',
 'rasterio',
 'requests',
 'scipy',
 'xarray',
 'zarr']

extras_require = \
{'doc': ['sphinx', 'sphinx_rtd_theme', 'black'],
 'test': ['testpath', 'responses', 'pytest>=2.7.3', 'pytest-cov']}

entry_points = \
{'console_scripts': ['hydromt = hydromt.cli.main:main']}

setup(name='hydromt',
      version='0.4.4',
      description='HydroMT: Build and analyze models like a data-wizard!',
      author=None,
      author_email='Dirk Eilander <dirk.eilander@deltares.nl>, Hélène Boisgontier <helene.boisgontier@deltares.nl>',
      url=None,
      packages=packages,
      package_data=package_data,
      install_requires=install_requires,
      extras_require=extras_require,
      entry_points=entry_points,
      python_requires='>=3.8',
     )
