"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Overview = exports.Image = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path = require("path");
const annotations_1 = require("./annotations");
class Image {
    constructor(filePath, title) {
        this.filePath = filePath;
        this.title = title;
    }
    /**
     * @internal
     */
    _bind(scope) {
        const extension = path.extname(this.filePath);
        if (![".jpeg", ".jpg", ".png", ".gif"].includes(extension)) {
            annotations_1.Annotations.of(scope).addWarning(`Unsupported file extension. Image "${this.filePath}" may be ignored.`);
        }
    }
    /**
     * @internal
     */
    _toThreagile() {
        return {
            [this.filePath]: this.title,
        };
    }
}
exports.Image = Image;
_a = JSII_RTTI_SYMBOL_1;
Image[_a] = { fqn: "cdktg.Image", version: "0.0.23" };
class Overview {
    constructor(props) {
        this.description = props.description;
        this.images = props.images;
    }
    /**
     * @internal
     */
    _toThreagile() {
        return {
            description: this.description,
            images: this.images?.map((i) => i._toThreagile()),
        };
    }
}
exports.Overview = Overview;
_b = JSII_RTTI_SYMBOL_1;
Overview[_b] = { fqn: "cdktg.Overview", version: "0.0.23" };
//# sourceMappingURL=data:application/json;base64,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