import { Construct, IConstruct } from "constructs";
import { AbuseCase } from "./abuse-case";
import { Author } from "./author";
import { Overview } from "./overview";
import { RiskTrackingProps } from "./risk-tracking";
import { SecurityRequirement } from "./security-requirement";
import { Threagile } from "./spec/threatgile.generated";
import { IModelSynthesizer } from "./synthesizer";
export interface Question {
    readonly text: string;
    readonly answer?: string;
}
export interface ModelProps {
    /**
     * Version of the Threagile toolkit
     */
    readonly version: string;
    /**
     * Title of the model
     */
    readonly title?: string;
    /**
     * Date of the model
     */
    readonly date?: string;
    /**
     * Author of the model
     */
    readonly author: Author;
    /**
     * Individual management summary for the report
     */
    readonly managementSummary?: string;
    /**
     * Business criticality of the target
     */
    readonly businessCriticality: BusinessCriticality;
    /**
     * Individual business overview for the report
     */
    readonly businessOverview?: Overview;
    /**
     * Individual technical overview for the report
     */
    readonly technicalOverview?: Overview;
    /**
     * Custom questions for the report
     */
    readonly questions?: Question[];
    /**
     * Custom abuse cases for the report
     */
    readonly abuseCases?: AbuseCase[];
    /**
     * Custom security requirements for the report
     */
    readonly securityRequirements?: SecurityRequirement[];
}
export declare class Model extends Construct {
    static isModel(x: any): x is Model;
    static of(construct: IConstruct): Model;
    readonly version: string;
    readonly title: string;
    readonly date?: string;
    readonly author: Author;
    readonly managementSummary?: string;
    readonly businessOverview?: Overview;
    readonly technicalOverview?: Overview;
    readonly businessCriticality: BusinessCriticality;
    synthesizer: IModelSynthesizer;
    private readonly questions;
    private readonly abuseCases;
    private readonly securityRequirements;
    private readonly tags;
    private readonly riskTracking;
    private readonly rawOverrides;
    constructor(project: Construct, id: string, props: ModelProps);
    addTag(tag: string): void;
    addTags(...tags: string[]): void;
    addQuestion(text: string, answer?: string): void;
    addAbuseCases(...cases: AbuseCase[]): void;
    addSecurityRequirements(...requirements: SecurityRequirement[]): void;
    trackRisk(id: string, options?: RiskTrackingProps): void;
    addOverride(path: string, value: unknown): void;
    /**
     * @internal
     */
    _toThreagile(): Threagile;
}
export declare enum BusinessCriticality {
    ARCHIVE = "archive",
    OPERATIONAL = "operational",
    IMPORTANT = "important",
    CRITICAL = "critical",
    MISSION_CRITICAL = "mission-critical"
}
