"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Quantity = exports.DataAsset = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const model_1 = require("./model");
const resource_1 = require("./resource");
class DataAsset extends resource_1.Resource {
    constructor(scope, id, props) {
        super(scope, id, props);
        this.usage = props.usage;
        this.tags = props.tags;
        this.origin = props.origin;
        this.owner = props.owner;
        this.quantity = props.quantity;
        this.ciaTriad = props.ciaTriad;
        if (this.tags && this.tags.length > 0) {
            const model = model_1.Model.of(this);
            model.addTags(...this.tags);
        }
    }
    /**
     * @internal
     */
    _toThreagile() {
        return {
            [this.node.id]: {
                id: this.uuid,
                description: this.description,
                usage: this.usage,
                tags: Array.from(new Set(this.tags)),
                origin: this.origin,
                owner: this.owner,
                quantity: this.quantity,
                ...this.ciaTriad._toThreagile(),
            },
        };
    }
}
exports.DataAsset = DataAsset;
_a = JSII_RTTI_SYMBOL_1;
DataAsset[_a] = { fqn: "cdktg.DataAsset", version: "0.0.23" };
var Quantity;
(function (Quantity) {
    Quantity["VERY_FEW"] = "very-few";
    Quantity["FEW"] = "few";
    Quantity["MANY"] = "many";
    Quantity["VERY_MANY"] = "very-many";
})(Quantity = exports.Quantity || (exports.Quantity = {}));
//# sourceMappingURL=data:application/json;base64,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