"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.SynthCommand = void 0;
const path = require("path");
const execa = require("execa");
const fs = require("fs-extra");
const which = require("which");
class SynthCommand {
    constructor() {
        this.command = "synth <filename>";
        this.describe = "synthesize the models";
        this.builder = (args) => {
            args.positional("filename", { demandOption: true, type: "string" });
            args.option("watch", {
                boolean: true,
                alias: "w",
                describe: "get watch with it!",
            });
            return args;
        };
        this.handler = async (args) => {
            const { filename } = args;
            if (!fs.existsSync(filename)) {
                throw new Error(`File ${filename} not exist!`);
            }
            const exitCode = await trySynth();
            if (args.watch) {
                watchLoop();
            }
            else {
                process.exit(exitCode);
            }
            function watchLoop() {
                console.log(`Watching for changes in ${filename}...`);
                const watch = fs.watch(filename, { recursive: true });
                watch.on("change", (event) => {
                    if (event !== "change") {
                        return;
                    }
                    process.stdout.write("\x1Bc"); // clear the screen
                    watch.close();
                    trySynth()
                        .then(() => watchLoop())
                        .catch(() => watchLoop());
                });
            }
            async function trySynth() {
                const command = await (async () => {
                    switch (path.extname(filename)) {
                        case ".ts":
                            return require.resolve("ts-node/dist/bin");
                        case ".py":
                            return which("python3", { all: false });
                        default:
                            throw new Error("Unknown file extension");
                    }
                })();
                const result = await execa(command, [filename], {
                    stdio: ["ignore", "inherit", "inherit"],
                });
                return result.exitCode;
            }
        };
    }
}
exports.SynthCommand = SynthCommand;
//# sourceMappingURL=data:application/json;base64,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