# Generated by Django 3.2.15 on 2022-10-09 14:10

import django.db.models.deletion
from django.db import migrations, models


class Migration(migrations.Migration):

    dependencies = [
        ("bpp", "0330_merge_20220921_2152"),
    ]

    operations = [
        migrations.AddField(
            model_name="jednostka",
            name="rodzaj_jednostki",
            field=models.CharField(
                choices=[
                    (
                        "normalna",
                        "zwyczajna jednostka (katedra, zakład, pracownia, itp.)",
                    ),
                    ("kolo_naukowe", "koło naukowe"),
                ],
                db_index=True,
                default="normalna",
                max_length=20,
            ),
        ),
        migrations.CreateModel(
            name="Kierunek_Studiow",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("nazwa", models.CharField(max_length=512, unique=True)),
                ("skrot", models.CharField(max_length=128, unique=True)),
                ("opis", models.TextField(blank=True, null=True)),
                ("adnotacje", models.TextField(blank=True, null=True)),
                (
                    "wydzial",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.PROTECT, to="bpp.wydzial"
                    ),
                ),
            ],
            options={
                "verbose_name": "kierunek studiów",
                "verbose_name_plural": "kierunki studiów",
                "ordering": ("nazwa",),
            },
        ),
        migrations.AddField(
            model_name="patent_autor",
            name="kierunek_studiow",
            field=models.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                to="bpp.kierunek_studiow",
            ),
        ),
        migrations.AddField(
            model_name="wydawnictwo_ciagle_autor",
            name="kierunek_studiow",
            field=models.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                to="bpp.kierunek_studiow",
            ),
        ),
        migrations.AddField(
            model_name="wydawnictwo_zwarte_autor",
            name="kierunek_studiow",
            field=models.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                to="bpp.kierunek_studiow",
            ),
        ),
    ]
