# Generated by Django 3.0.11 on 2021-03-07 22:29

from django.db import migrations, models

from bpp.migration_util import load_custom_sql


def ustaw_PAW_ZAW_PW(apps, schema_editor):
    Charakter_Formalny = apps.get_model("bpp", "Charakter_Formalny")
    for skrot in ["PAW", "ZAW"]:
        try:
            c = Charakter_Formalny.objects.get(skrot=skrot)
        except Charakter_Formalny.DoesNotExist:
            continue

        c.wliczaj_do_rankingu = False
        c.save()

    Typ_KBN = apps.get_model("bpp", "Typ_KBN")
    try:
        tk = Typ_KBN.objects.get(skrot="PW")
        tk.wliczaj_do_rankingu = False
        tk.save()
    except Typ_KBN.DoesNotExist:
        pass


class Migration(migrations.Migration):

    dependencies = [
        ("bpp", "0243_auto_20210307_1452"),
    ]

    operations = [
        migrations.AddField(
            model_name="charakter_formalny",
            name="wliczaj_do_rankingu",
            field=models.BooleanField(default=True),
        ),
        migrations.AddField(
            model_name="typ_kbn",
            name="wliczaj_do_rankingu",
            field=models.BooleanField(default=True),
        ),
        migrations.RunPython(
            lambda *args, **kw: load_custom_sql("0244_nowe_sumy_wliczaj_do")
        ),
        migrations.RunPython(ustaw_PAW_ZAW_PW),
    ]
