# Generated by Django 3.0.4 on 2020-05-24 22:34

from django.db import migrations, models

from bpp.models import CHARAKTER_OGOLNY_CHOICES


def guess_charakter_ogolny(apps, schema_editor):
    Charakter_Formalny = apps.get_model("bpp", "Charakter_Formalny")
    for elem in Charakter_Formalny.objects.all():
        if elem.charakter_ogolny == CHARAKTER_OGOLNY_CHOICES.inne:
            co = None

            if elem.charakter_pbn is not None:
                if elem.charakter_pbn.wlasciwy_dla == "article":
                    co = CHARAKTER_OGOLNY_CHOICES.artykul

                elif elem.charakter_pbn.wlasciwy_dla == "book":
                    co = CHARAKTER_OGOLNY_CHOICES.ksiazka

                elif elem.charakter_pbn.wlasciwy_dla == "chapter":
                    co = CHARAKTER_OGOLNY_CHOICES.rozdzial

            else:
                if elem.nazwa.lower().find("artyku") >= 0:
                    co = CHARAKTER_OGOLNY_CHOICES.artykul
                elif elem.nazwa.lower().find("książ") >= 0:
                    co = CHARAKTER_OGOLNY_CHOICES.ksiazka
                elif elem.nazwa.lower().find("rozdzia") >= 0:
                    co = CHARAKTER_OGOLNY_CHOICES.rozdzial

            if co is not None:
                elem.charakter_ogolny = co
                elem.save()
                continue


class Migration(migrations.Migration):

    dependencies = [
        ("bpp", "0211_oznaczenie_wydania"),
    ]

    operations = [
        migrations.AddField(
            model_name="charakter_formalny",
            name="charakter_ogolny",
            field=models.CharField(
                choices=[("ksi", "Książka"), ("roz", "Rozdział"), ("xxx", "Inne")],
                default="xxx",
                help_text="Charakter ogólny uzywany jest m.in. do generowania opisów bibliograficznych. Stanowi on\n        ogólne określenie rekordu, czy jest to książka, rozdział czy coś innego. ",
                max_length=3,
            ),
        ),
        migrations.RunPython(guess_charakter_ogolny, migrations.RunPython.noop),
    ]
